% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gc_position.R
\name{gc_position}
\alias{gc_position}
\title{Extract ORF Positions for One Specific Gene Cluster}
\usage{
gc_position(
  Data = orf_position.tmp,
  Cluster = cluster.tmp,
  EachCluster = eachcluster
)
}
\arguments{
\item{Data}{A numeric vector (ascending order) of ORF positions that carry
one of the reference genes of interest.  Usually the vector
\code{orf_position.tmp} created inside \code{gc_cal}.}

\item{Cluster}{Numeric vector returned by \code{\link{gc_cluster}}; each
element marks the \strong{last position} of a candidate cluster.}

\item{EachCluster}{Integer index specifying which cluster to extract
(1 = first cluster, 2 = second cluster, …).}
}
\value{
A numeric vector containing the ORF positions that constitute the
requested gene cluster.
}
\description{
Internal helper used by \code{\link{gc_cal}}.
Given the ordered positions of \strong{all} reference genes on a contig
(\code{Data}) and the vector of cluster breakpoints produced by
\code{\link{gc_cluster}} (\code{Cluster}), this function slices
\code{Data} to return the positions that belong to the
\code{EachCluster}-th cluster.
}
