% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEVfamily.R
\name{GEV}
\alias{GEV}
\alias{GEVfisher}
\alias{GEVquasi}
\alias{dGEV}
\alias{pGEV}
\alias{qGEV}
\alias{rGEV}
\title{GEV family distribution for fitting a GAMLSS}
\usage{
GEVfisher(mu.link = "identity", sigma.link = "log", nu.link = "identity")

GEVquasi(mu.link = "identity", sigma.link = "log", nu.link = "identity")

dGEV(x, mu = 0, sigma = 1, nu = 0, log = FALSE)

pGEV(q, mu = 0, sigma = 1, nu = 0, lower.tail = TRUE, log.p = FALSE)

qGEV(p, mu = 0, sigma = 1, nu = 0, lower.tail = TRUE, log.p = FALSE)

rGEV(n, mu = 0, sigma = 1, nu = 0)
}
\arguments{
\item{mu.link}{Defines the \code{mu.link}, with \code{"identity"} link as the default
for the \code{mu} parameter.}

\item{sigma.link}{Defines the \code{sigma.link}, with \code{"log"} link as the default
for the \code{sigma} parameter.}

\item{nu.link}{Defines the \code{nu.link}, with \code{"identity"} link as the default
for the \code{nu} parameter.}

\item{x, q}{Vector of quantiles.}

\item{mu, sigma, nu}{Vectors of location, scale and shape parameter values.}

\item{log, log.p}{Logical. If \code{TRUE}, probabilities \verb{eqn\{p\}} are given as
\eqn{\log(p)}.}

\item{lower.tail}{Logical. If \code{TRUE} (the default), probabilities are
\eqn{P[X \leq x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{Vector of probabilities.}

\item{n}{Number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}
}
\value{
\code{GEVfisher()} and \code{GEVquasi()} each return a
\code{\link[gamlss.dist:gamlss.family]{gamlss.dist::gamlss.family()}} object
which can be used to fit a regression model with a GEV response
distribution using the
\code{\link[gamlss:gamlss]{gamlss::gamlss()}} function. \code{dGEV()} gives the density,
\code{pGEV()} gives the distribution function, \code{qGEV()} gives the quantile
function, and \code{rGEV()} generates random deviates.
}
\description{
The functions \code{GEVfisher()} and \code{GEVquasi()} each define the generalized
extreme value (GEV) family distribution, a three parameter distribution, for
a \code{\link[gamlss.dist:gamlss.family]{gamlss.dist::gamlss.family()}} object to
be used in GAMLSS fitting using the function
\code{\link[gamlss:gamlss]{gamlss::gamlss()}}. The only difference
between \code{GEVfisher()} and \code{GEVquasi()} is the form of scoring method used to
define the weights used in the fitting algorithm. Fisher's scoring,
based on the expected Fisher information is used in \code{GEVfisher()}, whereas
a quasi-Newton scoring, based on the cross products of the first derivatives
of the log-likelihood, is used in \code{GEVquasi()}. The functions
\code{dGEV}, \code{pGEV}, \code{qGEV} and \code{rGEV} define the density, distribution function,
quantile function and random generation for the specific parameterization of
the generalized extreme value distribution given in \strong{Details} below.
}
\details{
The distribution function of a GEV distribution with parameters
\code{location} = \eqn{\mu}, \code{scale} = \eqn{\sigma (> 0)} and
\code{shape} = \eqn{\xi} (\eqn{= \nu}) is
\deqn{F(x \mid \mu, \sigma, \xi) = P(X \leq x) =
  \exp\left\{ -\left[ 1+\xi\left(\frac{x-\mu}{\sigma}\right) \right]_+^{-1/\xi} \right\},}
where \eqn{x_+ = \max(x, 0)}. If \eqn{\xi = 0} the
distribution function is defined as the limit as \eqn{\xi} tends to zero.
The support of the distribution depends on \eqn{\xi}: it is
\eqn{x \leq \mu - \sigma / \xi}{x <= \mu - \sigma / \xi} for \eqn{\xi < 0};
\eqn{x \geq \mu - \sigma / \xi}{x >= \mu - \sigma / \xi} for \eqn{\xi > 0};
and \eqn{x} is unbounded for \eqn{\xi = 0}.
See
\url{https://en.wikipedia.org/wiki/Generalized_extreme_value_distribution}
and/or Chapter 3 of Coles (2001) for further information.

For each observation in the data, the restriction that \eqn{\xi > -1/2} is
imposed, which is necessary for the usual asymptotic likelihood theory to be
applicable.
}
\section{Examples}{

See the examples in \code{\link[=fitGEV]{fitGEV()}}.
}

\references{
Coles, S. G. (2001) \emph{An Introduction to Statistical
Modeling of Extreme Values}, Springer-Verlag, London.
Chapter 3: \doi{10.1007/978-1-4471-3675-0_3}
}
\seealso{
\code{\link{fitGEV}},
\code{\link[gamlss.dist:gamlss.family]{gamlss.dist::gamlss.family()}},
\code{\link[gamlss:gamlss]{gamlss::gamlss()}}
}
