#' Annual Maximum Sea Levels at Fremantle, Western Australia
#'
#' This is a copy of the `fremantle` dataset from the `ismev` package.
#' The `fremantle` data frame has 86 rows and 3 columns. The second column
#' gives 86 annual maximum sea levels recorded at Fremantle, Western
#' Australia, within the period 1897 to 1989. The first column gives the
#' corresponding years. The third column gives annual mean values of the
#' Southern Oscillation Index (SOI), which is a proxy for meteorological
#' volatility.
#'
#' @format This data frame contains the following:
#'
#' * Year: A numeric vector of years.
#' * SeaLevel: A numeric vector of annual sea level maxima.
#' * SOI: A numeric vector of annual mean values of the Southern
#'   Oscillation Index.
#'
#' @source Coles, S. G. (2001) An Introduction to Statistical Modelling of
#' Extreme Values. London: Springer.
#' @examples
#' summary(fremantle)
"fremantle"
