% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-collapse.R
\name{collapse.data_request}
\alias{collapse.data_request}
\alias{collapse.metadata_request}
\alias{collapse.files_request}
\alias{collapse.prequery}
\alias{collapse.query}
\alias{collapse.query_set}
\title{Generate a query}
\usage{
\method{collapse}{data_request}(x, ...)

\method{collapse}{metadata_request}(x, ...)

\method{collapse}{files_request}(x, ...)

\method{collapse}{prequery}(x, ...)

\method{collapse}{query}(x, ...)

\method{collapse}{query_set}(x, ...)
}
\arguments{
\item{x}{An object to run \code{collapse()} on. Classes supported by \code{galah}
include \code{data_request}, \code{metadata_request} and \code{files_request} for building
queries; and \code{prequery}, \code{query} or \code{query_set} once constructed (via
\code{\link[=capture]{capture()}} or \code{\link[=compound]{compound()}}).}

\item{...}{Arguments passed on to \code{\link[=capture]{capture()}}.}
}
\value{
An object of class \code{query}, which is a list-like object containing
two or more of the following slots:
\itemize{
\item \code{type}: The type of query, serves as a lookup to the corresponding field in \code{show_all(apis)}
\item \code{url}: Either:
\itemize{
\item a length-1 character giving the API to be queried; or
\item a \code{tibble} containing at least the field \code{url} and optionally others
}
\item \code{headers}: headers to be sent with the API call
\item \code{body}: body section of the API call
\item \code{options}: options section of the API call
\item \code{request}: captures the supplied \verb{_request} object (see \code{\link[=galah_call]{galah_call()}})
}
}
\description{
Constructs a query so it can be inspected before being sent. \code{collapse()} can
be called at the end of a pipe that begins with \code{\link[=galah_call]{galah_call()}} to return the
constructed user query generated by the user's data request
(a \code{query} object). Objects
of class \code{data_request} (created using \code{\link[=request_data]{request_data()}}), \code{metadata_request}
(from \code{\link[=request_metadata]{request_metadata()}}) or \code{files_request} (from \code{\link[=request_files]{request_files()}}) are
all supported.
}
\details{
\code{galah} uses an object-based pipeline to convert piped requests into
valid queries, and to enact those queries with the specified organisation.
Typically, requests open with \code{\link[=galah_call]{galah_call()}} - though \code{\link[=request_metadata]{request_metadata()}}
and \code{\link[=request_files]{request_files()}} are also valid - and end with
\code{\link[=collect.data_request]{collect()}}. Under the hood,
the sequence of functions is as follows:

\code{\link[=capture]{capture()}} → \code{\link[=compound]{compound()}} →
\code{\link[=collapse.data_request]{collapse()}} →
\code{\link[=compute.data_request]{compute()}} →
\code{\link[=collect.data_request]{collect()}}

\code{\link[=collapse.data_request]{collapse()}} constructs a complete
user query, ready to be sent by
\code{\link[=compute.data_request]{compute()}}.
Information required to construct a complete user query are
provided by \code{\link[=capture]{capture()}} and \code{\link[=compound]{compound()}}, preceding functions to
parse and combine all required API calls necessary to build a user's query.
}
\seealso{
To open a piped query, see \code{\link[=galah_call]{galah_call()}}. For alternative
operations on \verb{_request} objects, see \code{\link[=capture]{capture()}}, \code{\link[=compound]{compound()}},
\code{\link[=compute.data_request]{compute()}} or
\code{\link[=collect.data_request]{collect()}}.
}
