% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xbar_r_varcomps.R
\name{part_to_part}
\alias{part_to_part}
\title{Average and Range Method Part-to-Part Variance Calculation}
\usage{
part_to_part(data, part, meas)
}
\arguments{
\item{data}{An R dataframe or tibble containing the required identifier and measurement columns.}

\item{part}{Column name (unquoted) specifying the unique ID of the part being measured. The column should be a
character or factor vector.}

\item{meas}{Column name (unquoted) where the measurement value is recorded. The column must be numeric and contain no
missing or infinite values.}
}
\value{
A number. The measure of part-to-part variation for the given data.
}
\description{
Average and Range Method Part-to-Part Variance Calculation
}
\examples{
data <- data.frame(
  SN = rep(c("SerialNumber_01","SerialNumber_02"), each = 4),
  Operator = rep(c("Operator_01","Operator_02"), each = 2, times = 2),
  Measure = c(0.0172,0.0177,0.0155,0.0159,0.0174,0.0181,0.0152,0.0176)
)
part_to_part(data, part = 'SN', meas = 'Measure')
}
