% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{snapline}
\alias{snapline}
\title{Configure Snapline Plugin}
\usage{
snapline(
  key = "snapline",
  tolerance = 5,
  offset = 20,
  autoSnap = TRUE,
  shape = "key",
  verticalLineStyle = list(stroke = "#1783FF"),
  horizontalLineStyle = list(stroke = "#1783FF"),
  filter = NULL,
  ...
)
}
\arguments{
\item{key}{Unique identifier for the plugin (string, default: NULL).}

\item{tolerance}{The alignment accuracy in pixels (number, default: 5).}

\item{offset}{The extension distance of the snapline (number, default: 20).}

\item{autoSnap}{Whether to enable automatic snapping (boolean, default: TRUE).}

\item{shape}{Specifies which shape to use as reference: "key" or a function
(string or JS function, default: "key").}

\item{verticalLineStyle}{Vertical snapline style (list or JS object, default: list(stroke = "#1783FF")).}

\item{horizontalLineStyle}{Horizontal snapline style (list or JS object, default: list(stroke = "#1783FF")).}

\item{filter}{Function to filter nodes that don't participate in alignment (JS function, default: NULL).}

\item{...}{Extra parameters.
See \url{https://g6.antv.antgroup.com/en/manual/plugin/snapline}.}
}
\value{
A list with the configuration settings for the snapline plugin.
}
\description{
Creates a configuration object for the snapline plugin in G6.
This plugin provides alignment guidelines when moving nodes.
}
\examples{
# Basic configuration
config <- snapline()

# Custom configuration
config <- snapline(
  key = "my-snapline",
  tolerance = 8,
  offset = 30,
  verticalLineStyle = list(
    stroke = "#f00",
    strokeWidth = 1.5,
    lineDash = c(5, 2)
  ),
  horizontalLineStyle = list(
    stroke = "#00f",
    strokeWidth = 1.5,
    lineDash = c(5, 2)
  )
)

# With custom filter function
config <- snapline(
  filter = JS("(node) => {
    // Only allow regular nodes to participate in alignment
    // Exclude special nodes like 'start' or 'end'
    const model = node.getModel();
    return model.type !== 'start' && model.type !== 'end';
  }")
)
}
