% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elements.R
\name{g6_node}
\alias{g6_node}
\alias{g6_edge}
\alias{g6_combo}
\alias{validate_element}
\alias{validate_element.g6_element}
\alias{validate_element.g6_node}
\alias{validate_element.g6_edge}
\alias{validate_element.g6_combo}
\title{G6 Graph Elements}
\usage{
g6_node(
  id,
  type = NULL,
  data = NULL,
  style = NULL,
  states = NULL,
  combo = NULL,
  children = NULL
)

g6_edge(
  source,
  target,
  id = paste(source, target, sep = "-"),
  type = NULL,
  data = NULL,
  style = NULL,
  states = NULL
)

g6_combo(
  id,
  type = NULL,
  data = NULL,
  style = NULL,
  states = NULL,
  combo = NULL
)

validate_element(x, ...)

\method{validate_element}{g6_element}(x, ...)

\method{validate_element}{g6_node}(x, ...)

\method{validate_element}{g6_edge}(x, ...)

\method{validate_element}{g6_combo}(x, ...)
}
\arguments{
\item{id}{Character. Unique identifier for the node or combo (required).
For edges, this is optional (id is constructed as source-target if not provided).}

\item{type}{Character. Element type (optional).}

\item{data}{List. Custom data for the element (optional).}

\item{style}{List. Element style (optional).}

\item{states}{Character vector. Initial states for the element (optional).}

\item{combo}{Character or NULL. Combo ID or parent combo ID (optional).}

\item{children}{Character vector. Child node IDs (optional, nodes only).}

\item{source}{Character. Source node ID (required, edges only).}

\item{target}{Character. Target node ID (required, edges only).}

\item{x}{An object of class \code{g6_element},
\code{g6_node}, \code{g6_edge}, or \code{g6_combo}.}

\item{...}{Additional arguments (unused).
the checks on source and target.}
}
\value{
An S3 object of class \code{g6_node}, \code{g6_edge}, or \code{g6_combo} (and \code{g6_element}).
}
\description{
Constructors and validators for G6 node, edge, and combo elements.
}
\examples{
# Create a node
node <- g6_node(
  id = "n1",
  type = "rect",
  data = list(label = "Node 1"),
  style = list(color = "red"),
  states = list("selected"),
  combo = NULL,
  children = c("n2", "n3")
)

# Create an edge
edge <- g6_edge(
  source = "n1",
  target = "n2",
  type = "line",
  style = list(width = 2)
)

# Create a combo
combo <- g6_combo(
  id = "combo1",
  type = "rect",
  data = list(label = "Combo 1"),
  style = list(border = "dashed"),
  states = list("active"),
  combo = NULL
)

# Validate a node explicitly
validate_element(node)
}
