% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchtools_multicore.R
\name{batchtools_multicore}
\alias{batchtools_multicore}
\title{A batchtools backend that resolves futures in parallel via forked background R processes}
\usage{
batchtools_multicore(
  ...,
  workers = availableCores(constraints = "multicore"),
  fs.latency = 0,
  delete = getOption("future.batchtools.delete", "on-success")
)
}
\arguments{
\item{workers}{The number of multicore processes to be
available for concurrent batchtools multicore futures.}

\item{fs.latency}{[\code{numeric(1)}]\cr
Expected maximum latency of the file system, in seconds.
Set to a positive number for network file systems like NFS which enables more robust (but also more expensive) mechanisms to
access files and directories.
Usually safe to set to \code{0} to disable the heuristic, e.g. if you are working on a local file system.}

\item{delete}{Controls if and when the batchtools job registry folder is
deleted.
If \code{"on-success"} (default), it is deleted if the future was resolved
successfully \emph{and} the expression did not produce an error.
If \code{"never"}, then it is never deleted.
If \code{"always"}, then it is always deleted.}

\item{\ldots}{Not used.}
}
\description{
A batchtools backend that resolves futures in parallel via forked background R processes
}
\details{
Batchtools multicore futures use \pkg{batchtools} cluster functions
created by \code{\link[batchtools:makeClusterFunctionsMulticore]{batchtools::makeClusterFunctionsMulticore()}} with
\code{ncpus = workers}.

An alternative to the batchtools multicore backend is to use
\code{plan(future::multicore)}.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(future)
plan(future.batchtools::batchtools_multicore, workers = 2)

message("Main process ID: ", Sys.getpid())

f <- future({
  data.frame(
    hostname = Sys.info()[["nodename"]],
          os = Sys.info()[["sysname"]],
       cores = unname(parallelly::availableCores()),
         pid = Sys.getpid(),
     modules = Sys.getenv("LOADEDMODULES")
  )
})
info <- value(f)
print(info)
\dontshow{\}) # examplesIf}
}
