% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_crit.R
\name{r_crit}
\alias{r_crit}
\title{Critical Value for Correlation Coefficient}
\usage{
r_crit(n, conf.level = 0.95, method = c("t"))
}
\arguments{
\item{n}{sample size(s) used to calculate correlations.
Values of \eqn{n < 4} are omitted.}

\item{conf.level}{confidence level for calculating the critical value(s).
Default is 0.95 (i.e., confidence of 95\%).
If length of the input is higher than 1, only the first element is used.}

\item{method}{Method for calculating the critical values.
Currently only the method based on \eqn{t}-distribution is used.}
}
\value{
A vector of critical values.
}
\description{
Calculate critical value for correlation coefficient,
for a given sample size and confidence level.
If absolute value of an observed correlation coefficient is higher
than the critical value, then the correlation is statistically significant
with the specified confidence.
This approach is
identical to using textbook tables of critical values and
alternative to calculating \eqn{p}-values.
}
\details{
Using Student's \eqn{t}-distribution, the critical value is
\deqn{r_{crit} = \frac{t}{\sqrt{n - 2 + t^2}},}
where \eqn{t} is a quantile of \eqn{t}-distribution with
\eqn{n - 2} degrees of freedom for probability \eqn{1 - (1 - conf.level)/2}.
}
\examples{
r_crit(120)
r_crit(20:30, conf.level = 0.9)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats]{cor.test}}, \code{\link[stats]{cor}}
}
\author{
Vyacheslav Lyubchich
}
\keyword{correlation}
\keyword{threshold}
