% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network-plot.R
\name{network_plot}
\alias{network_plot}
\title{funspotr Network Plot}
\usage{
network_plot(df, to = .data$pkgs, show_each_use = FALSE)
}
\arguments{
\item{df}{Dataframe containing columns \code{relative_paths}, \code{absolute_paths} and either \code{funs}
or \code{pkgs}. Generally the output from running:
\verb{github_spot_*() \%>\% unnest_results()}}

\item{to}{\code{funs} or \code{pkgs}}

\item{show_each_use}{Binary, default is \code{FALSE}. If \code{TRUE} edge thickness
will be based on the number of times a package or function is used.}
}
\value{
visNetwork plot
}
\description{
Output simple network plot using
\href{https://github.com/datastorm-open/visNetwork}{visNetwork} connecting either
\code{funs} or \code{pkgs} to \code{relative_paths}/\code{absolute_paths}.
}
\examples{
\dontrun{
library(dplyr)
library(funspotr)

gh_ex_pkgs <- list_files_github_repo(
  repo = "brshallo/feat-eng-lags-presentation",
  branch = "main") \%>\%
  spot_funs_files()

gh_ex_pkgs \%>\%
  unnest_results() \%>\%
  network_plot(to = pkgs)
}
}
