% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphaR.R
\name{alphaR}
\alias{alphaR}
\title{Generate random R matrices with a known coefficient alpha}
\usage{
alphaR(alpha, k, Nmats, SEED)
}
\arguments{
\item{alpha}{(numeric) A desired coefficient \eqn{\alpha} within 
the range \eqn{\alpha \in (-\infty, 1]}.}

\item{k}{(integer). The order of each R (correlation) matrix.}

\item{Nmats}{(integer) The number of fungible R matrices with a known 
\eqn{\alpha}. 
Default (\code{Nmats = 5}).}

\item{SEED}{(numeric)  The initial seed for the random number generator. 
If SEED is not supplied then the program will generate (and return) a randomly
generated seed.}
}
\value{
\itemize{
   \item  \strong{alpha} The desired (standardized) coefficient \eqn{\alpha}.
   \item \strong{R} The initial correlation matrix with a desired 
   coefficient \eqn{\alpha}. 
   \item \strong{Rlist} A list with \code{Nmats} fungible correlation 
   matrices with a desired coefficient \eqn{\alpha}.  
   \item  \strong{SEED} The initial value for the random number generator.
}
}
\description{
\code{alphaR} can generate a list of fungible correlation matrices with a 
user-defined  (standardized) coefficient \eqn{\alpha}.
}
\examples{

## Function to compute standardized alpha
Alphaz <- function(Rxx){
  k <- ncol(Rxx)
  k/(k-1) * (1 - (k/sum(Rxx)) ) 
}# END Alphaz

## Example 1
## Generate 25 6 x 6 R matrices with a standardized alpha of .85
alpha =  .85   
k = 6
Nmats =  25 
SEED = 1

out = alphaR(alpha, k , Nmats, SEED)
Alphaz(out$Rlist[[1]])

## Example 2
## Generate 25 6 x 6 R matrices with a standardized alpha of -5
alpha =  -5   
k = 6
Nmats =  25 
SEED = 1

out = alphaR(alpha, k , Nmats, SEED) 
Alphaz(out$Rlist[[5]])

}
\references{
Waller, N. & Revelle, W. (2023). What are the mathematical 
bounds for coefficient \eqn{\alpha}? \emph{Psychological Methods}.
 doi.org/10.1037/met0000583
}
\author{
Niels G. Waller
}
