% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbKMA-export.R
\docType{class}
\name{ProbKMA}
\alias{ProbKMA}
\title{ProbKMA Class}
\value{
A `ProbKMA` object from the C++ ProbKMA class.
}
\description{
The `ProbKMA` class is an R wrapper for the C++ implementation of the 
Probabilistic K-means Algorithm (ProbKMA) with local alignment. This class 
facilitates local clustering of functional data and functional motif discovery, 
as proposed in the paper 
`Probabilistic K-means with local alignment for clustering and motif discovery in functional data`, 
authored by Marzia A. Cremona and Francesca Chiaromonte.
}
\section{Constructor}{

Create a `ProbKMA` object using the following constructor:

\preformatted{
prok <- new(ProbKMA, data$Y, data$V, params, data$P0, data$S0, "H1")
}
}

\section{Parameters}{

\describe{
  \item{Y}{A list containing functional data and possibly derivatives.}
  \item{params}{An instance of the Parameters class, containing algorithm settings.}
  \item{P0}{A matrix representing the initial membership probabilities.}
  \item{S0}{A matrix representing the initial shift warping parameters.}
  \item{diss}{A character string specifying the dissimilarity measure. Possible choices are: 
    \itemize{
      \item `'d0_L2'`
      \item `'d1_L2'`
      \item `'d0_d1_L2'`
    }}
}
}

\section{Usage}{

You can access and modify the `ProbKMA` object with the following methods:
\describe{
  \item{Getters:}{
    \describe{
      \item{prok$get_parameters()}{Returns a list of parameters.}
      \item{prok$get_motifs()}{Returns a list containing the motifs found.}
    }
  }
  \item{Setters:}{
    \describe{
      \item{prok$set_P0(P)}{Sets the membership matrix.}
      \item{prok$set_S0(S)}{Sets the shift warping matrix.}
      \item{prok$set_parameters(param)}{Sets parameters field by passing a list of parameters.}
    }
  }
  \item{Initialize Motifs:}{
    \describe{
      \item{prok$reinit_motifs(c, d)}{Reinitializes (empty) K motifs with dimension c_k x d.}
    }
  }
  \item{Run ProbKMA algorithm:}{
    \describe{
      \item{prok$probKMA_run()}{Runs the algorithm.}
    }
  }
}
}

\author{
Niccolò Feresini and Riccardo Lazzarini
}
