% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/islands.R
\name{get_islands}
\alias{get_islands}
\title{Get list of Fortnite Creative islands}
\usage{
get_islands(limit = 50, offset = 0, order_by = "plays", order = "desc")
}
\arguments{
\item{limit}{Maximum number of results (default: 50)}

\item{offset}{Number of results to skip}

\item{order_by}{Field to order by ("plays", "lastPlayed", etc.)}

\item{order}{Sort order ("asc" or "desc")}
}
\value{
A tibble with island data
}
\description{
Get list of Fortnite Creative islands
}
\examples{
# Example with mock response
mock_response <- list(
  islands = list(
    list(code = "1234-5678-9012", title = "Mock Island"),
    list(code = "2345-6789-0123", title = "Test Island")
  )
)
# In practice, this would come from the API

\dontrun{
islands <- get_islands(limit = 50)
}
}
