% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/islands.R
\name{get_island_metrics}
\alias{get_island_metrics}
\title{Get island engagement metrics}
\usage{
get_island_metrics(code, start_date, end_date, interval = "day")
}
\arguments{
\item{code}{Island code}

\item{start_date}{Start date for metrics (Date or character)}

\item{end_date}{End date for metrics (Date or character)}

\item{interval}{Time interval ("minute", "hour", "day")}
}
\value{
A tibble with engagement metrics
}
\description{
Get island engagement metrics
}
\examples{
# Example with mock metrics structure
mock_metrics <- tibble::tibble(
  date = as.Date(c("2024-01-01", "2024-01-02")),
  dau = c(1000, 1200),
  play_duration = c(45.5, 48.2)
)
# In practice, this would come from the API

\dontrun{
metrics <- get_island_metrics(
  code = "1234-5678-9012",
  start_date = Sys.Date() - 7,
  end_date = Sys.Date(),
  interval = "day"
)
}
}
