% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/tostring.R
\name{toString}
\alias{toString}
\alias{toString,MatrixPrintForm-method}
\title{Transform objects into string representations}
\usage{
toString(x, ...)

\S4method{toString}{MatrixPrintForm}(
  x,
  widths = NULL,
  tf_wrap = FALSE,
  max_width = NULL,
  col_gap = mf_colgap(x),
  hsep = NULL,
  fontspec = font_spec(),
  ttype_ok = FALSE,
  round_type = obj_round_type(x)
)
}
\arguments{
\item{x}{(\code{ANY})\cr object to be prepared for rendering.}

\item{...}{additional parameters passed to individual methods.}

\item{widths}{(\code{numeric} or  \code{NULL})\cr Proposed widths for the columns of \code{x}. The expected
length of this numeric vector can be retrieved with \code{ncol(x) + 1} as the column of row names
must also be considered.}

\item{tf_wrap}{(\code{flag})\cr whether the text for title, subtitles, and footnotes should be wrapped.}

\item{max_width}{(\code{integer(1)}, \code{string} or \code{NULL})\cr width that title and footer (including
footnotes) materials should be word-wrapped to. If \code{NULL}, it is set to the current print width of the
session (\code{getOption("width")}). If set to \code{"auto"}, the width of the table (plus any table inset) is
used. Parameter is ignored if \code{tf_wrap = FALSE}.}

\item{col_gap}{(\code{numeric(1)})\cr space (in characters) between columns.}

\item{hsep}{(\code{string})\cr character to repeat to create header/body separator line. If
\code{NULL}, the object value will be used. If \code{" "}, an empty separator will be printed. See
\code{\link[=default_hsep]{default_hsep()}} for more information.}

\item{fontspec}{(\code{font_spec})\cr a font_spec object specifying the font information to use for
calculating string widths and heights, as returned by \code{\link[=font_spec]{font_spec()}}.}

\item{ttype_ok}{(\code{logical(1)})\cr should truetype (non-monospace) fonts be
allowed via \code{fontspec}. Defaults to \code{FALSE}. This parameter is primarily
for internal testing and generally should not be set by end users.}

\item{round_type}{(\code{string})\cr
The type of rounding to perform. Allowed values: (\code{"iec"}, \code{"iec_mod"} or \code{"sas"})
See \code{\link[=round_fmt]{round_fmt()}} for details.}
}
\value{
A character string containing the ASCII rendering of the table-like object represented by \code{x}.
}
\description{
Transform a complex object into a string representation ready to be printed or written
to a plain-text file.

All objects that are printed to console pass via \code{toString}. This function allows
fundamental formatting specifications to be applied to final output, like column widths
and relative wrapping (\code{width}), title and footer wrapping (\code{tf_wrap = TRUE} and
\code{max_width}), and horizontal separator character (e.g. \code{hsep = "+"}).
}
\details{
Manual insertion of newlines is not supported when \code{tf_wrap = TRUE} and will result in a warning and
undefined wrapping behavior. Passing vectors of already split strings remains supported, however in this
case each string is word-wrapped separately with the behavior described above.
}
\examples{
mform <- basic_matrix_form(mtcars)
cat(toString(mform))

}
\seealso{
\code{\link[=wrap_string]{wrap_string()}}
}
