% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastFunctions.R
\name{seasonal_test}
\alias{seasonal_test}
\title{Statistical test for seasonal behavior}
\usage{
seasonal_test(y, s_test = c("default", "unit_root"))
}
\arguments{
\item{y}{Object of time series class}

\item{s_test}{If \code{"default"} time series is tested for statistically seasonal behaviour. If \code{"unit_root"}, then First a difference is taken if a unit root is detected.}
}
\value{
A logical result indicating whether or not seasonal behavior was detected.
}
\description{
Statistical test for seasonal behavior
}
\details{
By default, the 90% significance seasonal Z-test, used by Assimakopoulos and Nikolopoulos (2000), is applied for quarterly and monthly time series.
The possibility of first checking the unit root was included because it was pointed out that this test presents many flaws for time series with this characteristic (Fiorucci et al, 2016)). In this case, the KPSS test is performed with a significance level of 5% and in the case of a unit root, then the series is differentiated before checking for seasonal behavior.
}
\examples{
\donttest{
seasonal_test(AirPassengers)
seasonal_test(AirPassengers, "unit")
}
}
\references{
Fiorucci J.A., Pellegrini T.R., Louzada F., Petropoulos F., Koehler, A. (2016). Models for optimising the theta method and their relationship to state space models, International Journal of Forecasting, 32 (4), 1151–1161, <doi:10.1016/j.ijforecast.2016.02.005>.
Assimakopoulos, V. and Nikolopoulos k. (2000). The theta model: a decomposition approach to forecasting. International Journal of Forecasting 16, 4, 521–530, <doi:10.1016/S0169-2070(00)00066-2>.
}
