% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf.R
\name{hrf_tent_generator}
\alias{hrf_tent_generator}
\title{Create Tent HRF Basis Set}
\usage{
hrf_tent_generator(nbasis = 5, span = 24)
}
\arguments{
\item{nbasis}{Number of tent basis functions (default: 5)}

\item{span}{Temporal window in seconds (default: 24)}
}
\value{
An HRF object of class \code{c("Tent_HRF", "HRF", "function")}
}
\description{
Generates an HRF object using tent (piecewise linear) basis functions with
custom parameters. This generator mirrors \code{HRF_TENT} but allows callers
to control the number of basis elements and temporal span.
}
\examples{
# Create a tent basis with 6 functions over a 20 second window
custom_tent <- hrf_tent_generator(nbasis = 6, span = 20)
t <- seq(0, 20, by = 0.1)
response <- evaluate(custom_tent, t)
matplot(t, response, type = "l", main = "Tent HRF with 6 basis functions")
}
\seealso{
\code{\link{HRF_objects}} for pre-defined HRF objects,
  \code{\link{getHRF}} for a unified interface to create HRFs,
  \code{\link{hrf_bspline_generator}} for a smoother alternative
}
