% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_statistical_outlier.R
\name{filter_highfreq_noise}
\alias{filter_highfreq_noise}
\title{Filter high frequency noise by Gaussian filter}
\usage{
filter_highfreq_noise(
  vctr_time,
  vctr_target,
  vctr_time_noise,
  wndw_size_noise = 13,
  inv_sigma_noise = 0.01,
  label_err = -9999
)
}
\arguments{
\item{vctr_time}{A timestamp vector of class POSIXct or POSIXt. The
timestamps must be equally spaced and arranged chronologically.}

\item{vctr_target}{A vector of a targeted time series to be checked. The
length of the time series must be the same as that of `vctr_time`.}

\item{vctr_time_noise}{A timestamp vector of class POSIXct or POSIXt,
indicating when high-frequency noise exists in the targeted time series.}

\item{wndw_size_noise}{A positive integer indicating the number of data
points included in a moving Gaussian window for the high-frequency noise
filtering. The default is 13, meaning that the window size is 6.5 hours if
the time interval of the input timestamp is 30 minutes.}

\item{inv_sigma_noise}{A positive value defining a Gaussian window width for
the high-frequency noise filtering. The width of the Gaussian window is
inversely proportional to this parameter. Default is 0.01.}

\item{label_err}{A numeric value representing a missing value in the input
vector(s). Default is -9999.}
}
\value{
A vector of the noise-filtered time series. The length of the time series is
the same as the input time series.
}
\description{
`filter_highfreq_noise()` filters a time series with a specific
 period by convolving it with a Gaussian window, removing high-frequency
 noise.
}
\examples{
## Create data
time <- seq(as.POSIXct("2026/01/01"), length.out = 360, by = "1 day")
x <- seq(1, 360)
target <- sin(x / 180 * pi) + stats::rnorm(length(x), sd = 0.2)
time_noise <-
  seq(as.POSIXct("2026/01/01"), as.POSIXct("2026/09/01"), by = "1 day")

## Filter noise
result <-
  filter_highfreq_noise(vctr_time = time, vctr_target = target,
                        vctr_time_noise = time_noise)

}
\author{
Yoshiaki Hata
}
