% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calc_sw_in_toa}
\alias{calc_sw_in_toa}
\title{Calculate global solar radiation time series at TOA}
\usage{
calc_sw_in_toa(
  vctr_time,
  lat,
  lon,
  std_meridian,
  solar_const = 1365,
  sbeta_min = 0.001
)
}
\arguments{
\item{vctr_time}{A timestamp vector of class POSIXct or POSIXt. The
timestamps must be equally spaced and arranged chronologically.}

\item{lat}{A numeric value (degrees) between -90 and 90, indicating the
latitude of the specific location.}

\item{lon}{A numeric value (degrees) between -180 and 180, indicating the
longitude of the specific location.}

\item{std_meridian}{A numeric value (degrees) between -180 and 180,
indicating the standard meridian of the specific location.}

\item{solar_const}{A positive value (W m-2) indicating the solar constant.
Default is 1365 (W m-2).}

\item{sbeta_min}{A threshold value of the solar elevation angle (degrees).
If the calculated solar elevation angle is less than this threshold, the
corresponding global solar radiation becomes zero.}
}
\value{
A vector of the global solar radiation at TOA (W m-2). The length of the
vector matches that of the input timestamp vector.
}
\description{
`calc_sw_in_toa()` obtains incident global solar radiation
 time series at TOA (top of atmosphere) at a specific location by
 calculating solar elevation angle estimated from the equations of Campbell
 and Norman (1998).
}
\examples{
## Make a timestamp vector
timezone <- "Etc/GMT-8"
time <- seq(as.POSIXct("2026/01/01", tz = timezone),
 as.POSIXct("2026/01/02", tz = timezone), by = "30 min")

## Obtain global solar radiation at Lambir Hills National Park in Malaysia
result <-
 calc_sw_in_toa(vctr_time = time, lat = 4.201007, lon = 114.039079,
                std_meridian = 120)

}
\author{
Yoshiaki Hata
}
