% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{distances_from_graph}
\alias{distances_from_graph}
\title{Compute Distance Matrix from Graph}
\usage{
distances_from_graph(graph_df, directed = FALSE, cost.column = "cost", ...)
}
\arguments{
\item{graph_df}{A data frame representing a graph with columns:
\code{from}, \code{to}, and \code{cost}.}

\item{directed}{Logical (default: FALSE). If TRUE, treats the graph as directed;
if FALSE, treats it as undirected.}

\item{cost.column}{Character string (optional). Name of the cost column in \code{graph_df}.
Alternatively, a numeric vector of edge costs with length equal to \code{nrow(graph_df)}.}

\item{\dots}{Additional arguments passed to \code{\link[igraph]{distances}()}, such as \code{v} (from) and \code{to} to compute paths between specific nodes.}
}
\value{
A matrix of distances between all node pairs, where rows and columns
  correspond to node IDs. The matrix contains the shortest path distances
  (based on the \code{cost} column) between all pairs of nodes.
}
\description{
Compute a distance matrix for all node pairs in a graph using \emph{igraph}.
}
\details{
This function:
\itemize{
  \item Converts the graph data frame to a \emph{igraph} graph object
  \item Contracts the graph for efficient distance computation
  \item Computes the distance matrix for all node pairs using the specified algorithm
}
}
\examples{
library(flownet)

# Create a simple graph
graph <- data.frame(
  from = c(1, 2, 2, 3),
  to = c(2, 3, 4, 4),
  cost = c(1, 2, 3, 1)
)

# Compute distance matrix
dmat <- distances_from_graph(graph, cost.column = "cost")
dmat

}
