% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{africa_cities_ports}
\alias{africa_cities_ports}
\title{African Cities and International Ports}
\format{
A Simple feature collection (sf object, also inheriting from data.table) with 453 POINT features and 12 fields:
\describe{
  \item{city_country}{Character. Unique city-country identifier (e.g., "Cairo - Egypt", "Lagos - Nigeria").}
  \item{city}{Character. City name.}
  \item{country}{Character. Country name.}
  \item{iso2}{Character. ISO 3166-1 alpha-2 country code.}
  \item{iso3}{Character. ISO 3166-1 alpha-3 country code.}
  \item{admin_name}{Character. Administrative region or province name.}
  \item{capital}{Character. Capital status: "" (none), "admin" (administrative), "minor", or "primary" (national capital).}
  \item{population}{Numeric. City population including nearby settlements within 30km.}
  \item{port_locode}{Character. UN/LOCODE port identifier (empty string for non-port cities).}
  \item{port_name}{Character. Official port name (empty string for non-port cities).}
  \item{port_status}{Character. Port status code (empty string for non-port cities).}
  \item{outflows}{Numeric. Outflows in TEU in Q1 of 2020 (NA for non-port cities). 51 cities have port outflow data.}
  \item{geometry}{POINT. Spatial geometry in WGS 84 (EPSG:4326) coordinate reference system.}
}
}
\source{
City data from Simplemaps World Cities Database (\url{https://simplemaps.com/data/world-cities}).
Port data from World Bank Global International Ports dataset (\url{https://datacatalog.worldbank.org/search/dataset/0038118/global-international-ports}).

Dataset constructed for: Krantz, S. (2024). Optimal Investments in Africa's Road Network.
Policy Research Working Paper 10893. World Bank. \doi{10.1596/1813-9450-10893}.
Replication materials: \url{https://github.com/SebKrantz/OptimalAfricanRoads}.
}
\usage{
data(africa_cities_ports)
}
\description{
A spatial dataset containing 453 major African cities (population > 100,000) and international ports.
Cities are deduplicated within 50-100km radii, with populations aggregated from nearby settlements.
Port cities include cargo flow data from the World Bank Global Ports dataset.
}
\details{
The dataset was constructed by:
\enumerate{
  \item Selecting cities with population > 50,000 from Simplemaps World Cities database
  \item Weighting by administrative importance (capital status)
  \item Deduplicating within 50-100km radii, keeping largest weighted city
  \item Aggregating populations from settlements within 30km
  \item Matching with World Bank international ports within 30km
}

The bounding box spans from approximately 34S to 37N latitude and 17W to 49E longitude,
covering continental Africa.
}
\examples{
library(sf)
data(africa_cities_ports)
head(africa_cities_ports)

# View largest cities
largest <- africa_cities_ports[order(-africa_cities_ports$population), ]
largest[1:10, c("city", "country", "population")]

# Filter port cities
ports <- africa_cities_ports[!is.na(africa_cities_ports$port_locode), ]
nrow(ports)  # 51 ports

\donttest{
plot(africa_cities_ports["population"])
}

}
\seealso{
\code{\link{africa_network}}, \code{\link{africa_trade}}, \link{flownet-package}
}
\keyword{datasets}
