% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_all_levels.R
\name{convert_all_levels}
\alias{convert_all_levels}
\title{Conversion of software specific levels}
\usage{
convert_all_levels(
  input_df,
  input_MQ_pg,
  software = c("MaxQuant", "DIA-NN", "Spectronaut", "PD")
)
}
\arguments{
\item{input_df}{A tibble with precursor, modified peptide and proteinGroup level information. For MaxQuant: evidence.txt and proteinGroups.txt, for PD: PSMs.txt with R-friendly headers enabled, for DIA-NN and Spectronaut default output reports.}

\item{input_MQ_pg}{For MaxQuant: A tibble with proteinGroup level information - proteinGroups.txt.}

\item{software}{The used analysis software - MaxQuant, PD, DIA-NN or Spectronaut. Default is MaxQuant.}
}
\value{
This function returns the original submitted \code{tibble} - input_df - including the following new columns:
\itemize{
\item traceR_precursor - software-independent standardized text for precursor entries.
\item traceR_precursor_unknownMods - logical value, if TRUE: a modification is detected, which is not converted to a standardized format.
\item traceR_mod.peptides - software-independent standardized text for modified peptide entries.
\item traceR_mod.peptides_unknownMods - logical value, if TRUE: a modification is detected, which is not converted to a standardized format.
\item traceR_proteinGroups - software-independent standardized text for proteinGroups.
}
}
\description{
Conversion of precursor, modified peptide and proteinGroup entries to standardized format.
}
\details{
The input entries are converted to a software independent format. The generated entries are appended to the submitted dataframe.
}
\examples{
# Load libraries
library(dplyr)
library(stringr)
library(tidyr)
library(comprehenr)
library(tibble)

# MaxQuant example data
evidence <- tibble::tibble(
  "Modified sequence" = c("_AACLLPK_",
   "_ALTDM(Oxidation (M))PQM(Oxidation (M))R_",
   "ALTDM(Dummy_Modification)PQMK"),
  Charge = c(2,2,3),
  "Protein group IDs" = c("26", "86;17", "86;17")
)

proteingroups <- tibble::tibble(
"Protein IDs" = c("A0A075B6P5;P01615;A0A087WW87;P01614;A0A075B6S6", "P02671", "P02672"),
id = c(26, 86, 17)
)

# Conversion
convert_all_levels(
 input_df = evidence,
 input_MQ_pg = proteingroups,
 software = "MaxQuant"
)
}
\author{
Oliver Kardell
}
