% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_tournament_data.R
\name{bind_tournament_data}
\alias{bind_tournament_data}
\title{Bind tournament data}
\usage{
bind_tournament_data(
  .,
  matches_data = NULL,
  round = NULL,
  team_a = NULL,
  team_b = NULL,
  winner = NULL,
  score_a = NULL,
  score_b = NULL,
  metadata = NULL,
  id = NULL,
  image = NULL,
  metadata_input_format = NULL,
  metadata_output_format = NULL,
  team_a_input_format = NULL,
  team_a_output_format = NULL,
  score_a_input_format = NULL,
  score_a_output_format = NULL,
  team_b_input_format = NULL,
  team_b_output_format = NULL,
  score_b_input_format = NULL,
  score_b_output_format = NULL,
  round_input_format = NULL,
  round_output_format = NULL,
  winner_input_format = NULL,
  winner_output_format = NULL,
  id_input_format = NULL,
  id_output_format = NULL,
  image_input_format = NULL,
  image_output_format = NULL
)
}
\arguments{
\item{.}{The prior Flourish object. No need to specify name if piping graph as the graph will take the first argument (i.e. the prior existing graph).}

\item{matches_data}{Matches data. teams.}

\item{round}{Stage. The stage of the tournament, for example "Round of 16" or "Semifinals". Flourish type hint: column}

\item{team_a}{Participant A. The first participant or team in this match. Flourish type hint: column}

\item{team_b}{Participant B. The second participant or team in this match. Flourish type hint: column}

\item{winner}{Winner. The winning participant or team in this match. Must match the name of either Participant A or Participant B. If left blank, the template will assume that the match is upcoming. Flourish type hint: column}

\item{score_a}{Participant A score. The score of Participant A in this match. Will appear along with the participants name in the box. Suggested data type hints: string, number. Flourish type hint: column}

\item{score_b}{Participant B score. The score of Participant B in this match. Will appear along with the participants name in the box. Suggested data type hints: string, number. Flourish type hint: column}

\item{metadata}{Info for popups. One or more columns of information (text,  image URLs ,  embedded charts  etc) to include in  popups and panels Suggested data type hints: string, number, datetime. Flourish type hint: columns}

\item{id}{ID. Participant ID. Should match a participants name from the Matches sheet. Flourish type hint: column}

\item{image}{Image. Image to render in the participant box. Add an image URL or right-click on a cell to upload an image. Flourish type hint: column}

\item{metadata_input_format}{Formats/parses dates, strings, and numbers for the metadata column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{metadata_output_format}{Formats/parses dates, strings, and numbers for the metadata column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{team_a_input_format}{Formats/parses dates, strings, and numbers for the team_a column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{team_a_output_format}{Formats/parses dates, strings, and numbers for the team_a column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{score_a_input_format}{Formats/parses dates, strings, and numbers for the score_a column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{score_a_output_format}{Formats/parses dates, strings, and numbers for the score_a column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{team_b_input_format}{Formats/parses dates, strings, and numbers for the team_b column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{team_b_output_format}{Formats/parses dates, strings, and numbers for the team_b column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{score_b_input_format}{Formats/parses dates, strings, and numbers for the score_b column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{score_b_output_format}{Formats/parses dates, strings, and numbers for the score_b column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{round_input_format}{Formats/parses dates, strings, and numbers for the round column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{round_output_format}{Formats/parses dates, strings, and numbers for the round column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{winner_input_format}{Formats/parses dates, strings, and numbers for the winner column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{winner_output_format}{Formats/parses dates, strings, and numbers for the winner column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{id_input_format}{Formats/parses dates, strings, and numbers for the id column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{id_output_format}{Formats/parses dates, strings, and numbers for the id column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{image_input_format}{Formats/parses dates, strings, and numbers for the image column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{image_output_format}{Formats/parses dates, strings, and numbers for the image column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}
}
\value{
A Flourish chart
}
\description{
Bind tournament data
}
\examples{
try(
  flourish(chart_type = "tournament", api_key = Sys.getenv("FLOURISH_API_KEY")) |> 
  bind_tournament_data(gapminder)
)
}
