% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_radar_data.R
\name{bind_radar_data}
\alias{bind_radar_data}
\title{Bind radar chart data}
\usage{
bind_radar_data(
  .,
  data = NULL,
  name = NULL,
  values = NULL,
  filter = NULL,
  color_category = NULL,
  facet = NULL,
  metadata = NULL,
  color_category_input_format = NULL,
  color_category_output_format = NULL,
  filter_input_format = NULL,
  filter_output_format = NULL,
  facet_input_format = NULL,
  facet_output_format = NULL,
  metadata_input_format = NULL,
  metadata_output_format = NULL,
  name_input_format = NULL,
  name_output_format = NULL,
  values_input_format = NULL,
  values_output_format = NULL
)
}
\arguments{
\item{.}{The prior Flourish object. No need to specify name if piping graph as the graph will take the first argument (i.e. the prior existing graph).}

\item{data}{Data.}

\item{name}{Name. A text column containing a name for each radar. Suggested data type hints: string. Flourish type hint: column}

\item{values}{Values. Select three or more numerical columns. Suggested data type hints: number. Flourish type hint: columns}

\item{filter}{Filter. If set, creates a filter menu or time slider. Suggested data type hints: string, number, datetime. Flourish type hint: column}

\item{color_category}{Color category. Add a category to color by If empty, the name column will be used for colors. Suggested data type hints: string. Flourish type hint: column}

\item{facet}{Grid of charts (facet). Create one column for each grouping you want to allow. Suggested data type hints: string. Flourish type hint: columns}

\item{metadata}{Info for popups. One or more columns of information (text, image URLs, embedded charts etc) to include in custom popups and panels Suggested data type hints: string, datetime, number. Flourish type hint: columns}

\item{color_category_input_format}{Formats/parses dates, strings, and numbers for the color_category column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{color_category_output_format}{Formats/parses dates, strings, and numbers for the color_category column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{filter_input_format}{Formats/parses dates, strings, and numbers for the filter column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{filter_output_format}{Formats/parses dates, strings, and numbers for the filter column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{facet_input_format}{Formats/parses dates, strings, and numbers for the facet column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{facet_output_format}{Formats/parses dates, strings, and numbers for the facet column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{metadata_input_format}{Formats/parses dates, strings, and numbers for the metadata column. If string: any arbritrary string. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{metadata_output_format}{Formats/parses dates, strings, and numbers for the metadata column. If string: any arbritrary string. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{name_input_format}{Formats/parses dates, strings, and numbers for the name column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{name_output_format}{Formats/parses dates, strings, and numbers for the name column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{values_input_format}{Formats/parses dates, strings, and numbers for the values column. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{values_output_format}{Formats/parses dates, strings, and numbers for the values column. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}
}
\value{
A Flourish chart
}
\description{
Bind radar chart data
}
\examples{
try(
  flourish(chart_type = "radar", api_key = Sys.getenv("FLOURISH_API_KEY")) |> 
  bind_radar_data(gapminder)
)
}
