% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum.r
\name{sum}
\alias{sum}
\alias{sum,float32-method}
\title{sum}
\usage{
\S4method{sum}{float32}(x, ..., na.rm = FALSE)
}
\arguments{
\item{x}{A float matrix.}

\item{...}{Additional elements (numeric/float vectors/matrices) to sum.}

\item{na.rm}{should NA's be removed?}
}
\value{
A single value.
}
\description{
Sums any combination of float/numeric vector(s)/matri[x|ces].
}
\details{
If there are any elements in \code{...}, all elements in the list will first
be summed in their native precision, then converted to double precision so
they can be combined with \code{base::sum()}.  The final result will be cast
to single precision if \code{...} contains only integer and/or float objects.
Otherwise, the return will be double precision.
}
\examples{
library(float)
x = flrunif(10, 3)

sum(x)
sum(x, 1)

}
