% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backsolve.r
\name{backsolve}
\alias{backsolve}
\alias{backsolve,float32,float32-method}
\alias{backsolve,float32,BaseLinAlg-method}
\alias{backsolve,BaseLinAlg,float32-method}
\alias{forwardsolve,float32,float32-method}
\alias{forwardsolve,float32,BaseLinAlg-method}
\alias{forwardsolve,BaseLinAlg,float32-method}
\title{backsolve}
\usage{
\S4method{backsolve}{float32,float32}(r, x, k = ncol(r), upper.tri = TRUE, transpose = FALSE)

\S4method{backsolve}{float32,BaseLinAlg}(r, x, k = ncol(r), upper.tri = TRUE, transpose = FALSE)

\S4method{backsolve}{BaseLinAlg,float32}(r, x, k = ncol(r), upper.tri = TRUE, transpose = FALSE)

\S4method{forwardsolve}{float32,float32}(l, x, k = ncol(l), upper.tri = FALSE, transpose = FALSE)

\S4method{forwardsolve}{float32,BaseLinAlg}(l, x, k = ncol(l), upper.tri = FALSE, transpose = FALSE)

\S4method{forwardsolve}{BaseLinAlg,float32}(l, x, k = ncol(l), upper.tri = FALSE, transpose = FALSE)
}
\arguments{
\item{r, l}{A triangular coefficients matrix.}

\item{x}{The right hand sides.}

\item{k}{The number of equations (columns of r + rows of x) to use.}

\item{upper.tri}{Should the upper triangle be used? (if not the lower is)}

\item{transpose}{Should the transposed coefficients matrix be used? More efficient than
manually transposing with \code{t()}.}
}
\description{
Solve a triangular system.
}
\examples{
library(float)

s = flrunif(10, 3)
cp = crossprod(s)
y = fl(1:3)
backsolve(cp, y)

}
