% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-patches.R
\name{get_patches}
\alias{get_patches}
\title{Detect patches of cells}
\usage{
get_patches(x, directions, cells = "all")
}
\arguments{
\item{x}{SpatRaster}

\item{directions}{integer. Which cells are considered adjacent: \code{4} for rooks case (horizontal and vertical neighbours) or \code{8} for queens case (horizontal, vertical and diagonal neighbours)}

\item{cells}{character / vector. Either \code{"all"} or a vector with specific cell values. If \code{cells="all"}, patches are identified based on all non-\code{NA} cells in \code{x}. Otherwise, patches are only identified for cells in \code{x} with the specific cell values.}
}
\value{
SpatRaster with patches of cells. The value of the cells represent the id of the patches.
}
\description{
The function detects patches of cells based on rook contiguity (horizontal and vertical neighbours) or queen contiguity (horizontal, vertical and diagonal neighbours).

Patches of cells are groups of cells that are surrounded by \code{NA} of \code{NaN} values. The function identifies patches by converting the SpatRaster into polygons with the functions \code{geos::as_geos_geometry()} and \code{geos::geos_unnest()}. During this conversion polygons are automatically created as cells with rook contiguity. Touching polygons are afterwards dissolved to create patches with queen contiguity.

The function is similar as \code{terra::patches()}, but is faster for large SpatRasters (see details).
}
\details{
The function is similar as \code{terra::patches()}, but is faster for large SpatRasters.

\strong{Rook contiguity}\tabular{lll}{
   Size SpatRaster \tab \code{terra::patches(directions=4)} \tab \code{flexurba::get_patches(directions=4)} \cr
   4000 x 4000 (106 642 not-\code{NA} cells) \tab 75.157 s \tab 5.351 s \cr
   4000 x 4000 (423 888 not-\code{NA} cells) \tab 324.846 s \tab 8.336 s \cr
}


\strong{Queen contiguity}\tabular{lll}{
   Size SpatRaster \tab \code{terra::patches(directions=8)} \tab \code{flexurba::get_patches(directions=8)} \cr
   4000 x 4000 (106 642 not-\code{NA} cells) \tab 37.322 s \tab 7.737 s \cr
   4000 x 4000 (423 888 not-\code{NA} cells) \tab 183.428 s \tab 24.094 s \cr
}
}
\examples{
r <- terra::rast(nrows = 8, ncols = 8, vals = c(
  2, 2, NA, NA, NA, NA, NA, NA,
  NA, NA, NA, NA, NA, NA, NA, NA,
  NA, NA, 1, NA, NA, NA, NA, NA,
  NA, NA, NA, 1, NA, NA, NA, NA,
  NA, NA, NA, NA, 1, 1, 1, 1,
  NA, NA, NA, NA, NA, 1, 1, 1,
  2, NA, NA, NA, NA, NA, NA, NA,
  NA, 2, NA, NA, NA, NA, NA, NA
))
terra::plot(r)
patches_rook1 <- get_patches(r, directions = 4)
terra::plot(patches_rook1)
patches_rook2 <- get_patches(r, directions = 4, cells = 1)
terra::plot(patches_rook2)
patches_queen1 <- get_patches(r, directions = 8)
terra::plot(patches_queen1)
patches_queen2 <- get_patches(r, directions = 8, cells = 1)
terra::plot(patches_queen2)
}
