% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flxregnorm.R
\name{FLXMCregnorm_defaults}
\alias{FLXMCregnorm_defaults}
\title{Data-Driven Default Parameters for Regularized Normal Mixtures}
\usage{
FLXMCregnorm_defaults(x, zeta_p = NULL, kappa_p = 0.01, nu_p = 3, k = NULL)
}
\arguments{
\item{x}{The data set to be clustered. Should be the same data set
as is used in \code{\link[flexmix:flexmix]{flexmix::flexmix()}}'s model formula.}

\item{zeta_p}{Scale (hyperparameter for IG prior). If not given the
empirical variance divided by the square of the number of
components is used as per Fraley and Raftery (2007).

\code{mu_p} is computed from the data as the overall means across all
components.

A value for the scale hyperparameter \code{zeta_p} may be specified directly.
Otherwise the empirical variance divided by the square of the number of
components is used as per Fraley and Raftery (2007). In which case the
number of components (parameter \code{k}) needs to be specified.}

\item{kappa_p}{Shrinkage parameter. Corresponds to adding \code{kappa_p}
observations according to the population mean to each component
(hyperparameter for IG prior)}

\item{nu_p}{Degress of freedom (hyperparameter for IG prior)}

\item{k}{Number of components assumed for the mixture model (not
used if \code{zeta_p} is given).}
}
\value{
A named list with values for \code{mu_p}, \code{kappa_p}, \code{nu_p} and \code{zeta_p}.
}
\description{
Determines the default values for regularized univariate normal
mixtures as proposed by Fraley and Raftery (2007) based on the data
set to be clustered and the number of components in the mixture
model.
}
