% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invgamma.R
\name{invgamma}
\alias{invgamma}
\alias{dinvgamma}
\alias{pinvgamma}
\alias{qinvgamma}
\alias{rinvgamma}
\title{Inverse Gamma Distribution}
\usage{
dinvgamma(x, shape = 2.5, scale = 1, log = FALSE)

pinvgamma(q, shape = 2.5, scale = 1, lower.tail = TRUE, log.p = FALSE)

qinvgamma(p, shape = 2.5, scale = 1, lower.tail = TRUE, log.p = FALSE)

rinvgamma(n, shape = 2.5, scale = 1)
}
\arguments{
\item{x}{numeric value or a vector of values.}

\item{shape}{numeric value or vector of shape values for the distribution
(the values have to be greater than 0).}

\item{scale}{single value or vector of values for the scale parameter of the
distribution (the values have to be greater than 0).}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{quantile or a vector of quantiles.}

\item{lower.tail}{logical; if TRUE, probabilities p are \eqn{P[X\leq x]}
otherwise, \eqn{P[X>x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{probability or a vector of probabilities.}

\item{n}{the number of random numbers to generate.}
}
\value{
dinvgamma gives the density, pinvgamma gives the distribution 
 function, qinvgamma gives the quantile function, and rinvgamma generates
 random  deviates.

 The length of the result is determined by n for rinvgamma, and is the 
 maximum of the lengths of the numerical arguments for the other functions.
}
\description{
These functions provide the density function, distribution function, quantile
function, and random number generation for the Inverse-Gamma (IG)
Distribution
}
\details{
\code{dinvgamma} computes the density (PDF) of the Inverse-Gamma
Distribution.

\code{pinvgamma} computes the CDF of the Inverse-Gamma Distribution.

\code{qinvgamma} computes the quantile function of the Inverse-Gamma
Distribution.

\code{rinvgamma} generates random numbers from the Inverse-Gamma
Distribution.

The compound Probability Mass Function (PMF) for the Inverse-Gamma
distribution:
\deqn{f(x | \alpha, \beta) = 
    \frac{\beta^\alpha}{\Gamma(\alpha)}
    \left(\frac{1}{x}\right)^{\alpha+1} e^{-\frac{\beta}{x}}}

Where \eqn{\alpha} is the shape parameter and \eqn{\beta} is a scale
parameter with the restrictions that \eqn{\alpha > 0} and \eqn{\eta > 0}, and
\eqn{x > 0}.

The CDF of the Inverse-Gamma distribution is:
\deqn{F(x | \alpha, \beta) = 
   \frac{\alpha. \Gamma \left(\frac{\beta}{x}\right)}{\Gamma(\alpha)} = 
   Q\left(\alpha, \frac{\beta}{x} \right)}

Where the numerator is the incomplete gamma function and \eqn{Q(\cdot)} is
the regularized gamma function.

The mean of the distribution is (provided \eqn{\alpha>1}):
\deqn{\mu=\frac{\beta}{\alpha-1}}

The variance of the distribution is (for \eqn{\alpha>2}):
\deqn{\sigma^2=\frac{\beta^2}{(\alpha-1)^2(\alpha-2)}}
}
\examples{
dinvgamma(1, shape = 3, scale = 2)
pinvgamma(c(0.1, 0.5, 1, 3, 5, 10, 30), shape = 3, scale = 2)
qinvgamma(c(0.1, 0.3, 0.5, 0.9, 0.95), shape = 3, scale = 2)
rinvgamma(30, shape = 3, scale = 2)

}
