% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plindLnorm.R
\name{PoissonLindleyLognormal}
\alias{PoissonLindleyLognormal}
\alias{dplindLnorm}
\alias{pplindLnorm}
\alias{qplindLnorm}
\alias{rplindLnorm}
\title{Poisson-Lindley-Lognormal Distribution}
\usage{
dplindLnorm(
  x,
  mean = 1,
  theta = 1,
  sigma = 1,
  ndraws = 1500,
  log = FALSE,
  hdraws = NULL
)

pplindLnorm(
  q,
  mean = 1,
  theta = 1,
  lambda = NULL,
  sigma = 1,
  ndraws = 1500,
  lower.tail = TRUE,
  log.p = FALSE
)

qplindLnorm(p, mean = 1, theta = 1, sigma = 1, ndraws = 1500, lambda = NULL)

rplindLnorm(n, mean = 1, theta = 1, sigma = 1, ndraws = 1500, lambda = NULL)
}
\arguments{
\item{x}{numeric value or vector of values.}

\item{mean}{mean (>0).}

\item{theta}{Poisson-Lindley theta parameter (>0).}

\item{sigma}{lognormal sigma parameter (>0).}

\item{ndraws}{number of Halton draws.}

\item{log}{return log-density.}

\item{hdraws}{optional Halton draws.}

\item{q}{quantile or vector of quantiles.}

\item{lambda}{optional lambda parameter (>0).}

\item{lower.tail}{TRUE returns P[X \deqn{\leq} x].}

\item{log.p}{return log-CDF.}

\item{p}{probability or vector of probabilities.}

\item{n}{number of random draws.}
}
\value{
dplindLnorm gives the density, pplindLnorm gives the distribution 
 function, qplindLnorm gives the quantile function, and rplindLnorm generates
 random  deviates.

 The length of the result is determined by n for rplindLnorm, and is the 
 maximum of the lengths of the numerical arguments for the other functions.
}
\description{
These functions provide density, distribution, quantile, and random
generation for the Poisson-Lindley-Lognormal (PLL) Distribution.
}
\details{
The PLL is a 3-parameter count distribution that captures high mass at
small y and allows flexible heavy tails.


\code{dplind} computes the PLL density.
\code{pplind} computes the PLL CDF.
\code{qplind} computes quantiles.
\code{rplind} generates random draws.

The PMF is:
\deqn{
f(y|\mu,\theta,\sigma)=\int_0^\infty
  \frac{\theta^2\mu^y x^y(\theta+\mu x+y+1)}
       {(\theta+1)(\theta+\mu x)^{y+2}}
  \frac{\exp\left(-\frac{\ln^2(x)}{2\sigma^2}\right)}
       {x\sigma\sqrt{2\pi}}dx
}

Mean:
\deqn{
E[y]=\mu=\frac{\lambda(\theta+2)e^{\sigma^2/2}}
            {\theta(\theta+1)}
}

Halton draws are used to evaluate the integral.
}
\examples{
dplindLnorm(0, mean=0.75, theta=7, sigma=2, ndraws=10)
pplindLnorm(0:10, mean=0.75, theta=7, sigma=2, ndraws=10)
qplindLnorm(c(0.1,0.5,0.9), lambda=4.67, theta=7, sigma=2)
rplindLnorm(5, mean=0.75, theta=7, sigma=2)

}
