% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPolyTools.R
\name{readDatfile}
\alias{readDatfile}
\title{User-friendly wrapper for read.table}
\usage{
readDatfile(file, header=TRUE, sep="\t", check.names=FALSE, ...)
}
\arguments{
\item{file}{the name of the file which the data are to be read from}

\item{header}{a logical value indicating whether the file contains the names
of the data.frame columns as its first line}

\item{sep}{the field separator character}

\item{check.names}{logical. If FALSE (default), column names are not checked.
This is important if column names are the names of samples, markers etc that
may not be syntactically valid variable names.\cr
If TRUE then the names of the variables in the data frame are checked to
ensure that they are syntactically valid variable names. If necessary they
are adjusted (by make.names) so that they are, and also to ensure that there
are no duplicates}

\item{...}{Further arguments to be passed to read.table}
}
\value{
A data.frame containing a representation of the data in the file
}
\description{
A wrapper for read.table that has default parameter values for
reading tab-separated files as used in packages fitPoly and fitPolyTools
}
