% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPolyTools.R
\docType{package}
\name{fitPolyTools}
\alias{fitPolyTools}
\title{fitPolyTools: a package with functions related to package fitPoly}
\description{
Package fitPolyTools offers some functions for preparing and selecting
input data for package fitPoly, and for inspection and analysis
of polyploid dosage calls as produced by fitPoly. These analyses focus
on the segregation of dosages in an F1 progeny of two parents. The functions
can be grouped as follows:
}
\section{data preparation functions}{

Functions readFullDataTable and readAxiomSummary convert files generated by
Illumina's GenomeStudio and Affymetrix Power Tools software to the input
format for fitPoly::fitPoly and fitPoly::fitMarkers.
}

\section{data visualization functions}{

Functions XYplot and drawXYplots draw scatterplots of the samples for one
marker at a time, possibly with colors indicating the assigned dosages and/or
highlighting specific samples. Function combineFiles combines X and Y columns
from one file or data.frame with column geno from another.
}

\section{segregation type functions}{

The functions calcSegtypeInfo, selSegtypeInfo and segtypeInfoSummary
produce information on the possible F1 segregation types. These functions
are primarily developed for use in other functions but are also available
for users.
}

\section{identification of the probable segregation types}{

Function checkF1 gives for all markers the most likely (best fitting)
segregation type, based on the F1 and the parental samples. Function
correctDosages checks for possibly "shifted" markers (e.g. all dosages
scored one lower or higher than the true dosage).
Function checkF1 can apply shifts when specified.
}

\section{combining data from two probes for the same SNP}{

On Affymetrix Axiom SNP arrays it is possible to have the same SNP
interrogated from both sides by two different probes. Function compareProbes
compares the results from both probes and produces a new, merged marker if
they are sufficiently similar. It also writes the results to a data file
suitable for linkage mapping functions (package polymapR).\cr
Function removeRedundant takes the result of compareProbes; if a merged
marker is present it removes the corresponding separate probe markers.
}

\section{producing a data file for mapping}{

Function writeDosagefile produces a data file suitable for linkage mapping
functions (package polymapR). This data file has the same format as that
produced by compareProbes and removeRedundant (see previous section).\cr
Function F1Dosages2Matrix reads such a dosages file and returns a matrix
in the format required by the polymapR package.
}

\section{reformatting of fitPoly scores file}{

Function scores2wide reformats the scores file produced by the
fitMarkers function of the fitPoly package to "wide" format.
}

\section{recovery functions}{

Functions getBatchfiles and concatbatch allow to recover results from already
processed batches of markers, in case fitMarkers crashes.
}

\section{general tools}{

These tools may be useful by themselves and are therefore made available too.
They include leftstr and rightstr: two functions that return substrings from
the left or right side, and function checkFilename which tests if a file
with the name can be created. Functions readDatfile and writeDatfile are
wrappers for read.table and write.table with different default options,
suitable for the file formats expected or produced by functions in this
package oand fitPoly.
}

