% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vocabulary_data.R
\name{get_vocabulary_data}
\alias{get_vocabulary_data}
\title{Get and structure RDF data of the whole vocabulary or a specific concept from the Finto Skosmos API}
\usage{
get_vocabulary_data(
  vocid,
  format = "application/rdf+xml",
  uri = NULL,
  lang = NULL
)
}
\arguments{
\item{vocid}{The vocabulary ID, e.g., "yso".}

\item{format}{The MIME type of the serialization format, e.g., "application/rdf+xml". Default is "application/rdf+xml".}

\item{uri}{The URI of a specific concept to retrieve data for. If NULL, retrieves data for the entire vocabulary. Optional.}

\item{lang}{The RDF language code for the requested resource, e.g., "fi" or "en". Optional.}
}
\value{
A character string containing the raw RDF response.
}
\description{
Get and structure RDF data of the whole vocabulary or a specific concept from the Finto Skosmos API
}
\examples{
\donttest{
rdf_xml_data <- get_vocabulary_data(
  vocid = "yso",
  uri = "http://www.w3.org/2004/02/skos/core#Concept",
  format = "application/rdf+xml"
)
cat(rdf_xml_data)

turtle_data <- get_vocabulary_data(
  vocid = "yso",
  format = "text/turtle"
)
cat(turtle_data)  # Print the Turtle data
}
}
