% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_resources.R
\name{as_fhir}
\alias{as_fhir}
\title{Coerce character vector to \linkS4class{fhir_bundle_list}}
\usage{
as_fhir(x)
}
\arguments{
\item{x}{A character vector where each element is a string representing an xml FHIR bundle.}
}
\description{
Tries to convert a character vector containing xml strings representing FHIR bundles to an object of
class \linkS4class{fhir_bundle_list}.
}
\examples{

#character vector containing fhir bundles
bundle_strings <- c(
"<Bundle>
 <type value='searchset'/>
 <entry>
  <resource>
    <Patient>
       <id value='id1'/>
	      <name>
	         <given value='Marie'/>
	      </name>
    </Patient>
  </resource>
 </entry>
</Bundle>",
"<Bundle>
 <type value='searchset'/>
 <entry>
  <resource>
    <Patient>
       <id value='id2'/>
	      <name>
	         <given value='Max'/>
	      </name>
    </Patient>
  </resource>
 </entry>
</Bundle>"
)

#convert to FHIR bundle list
bundles <- as_fhir(bundle_strings)

}
