% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_ensure.R
\name{type_ensure}
\alias{type_ensure}
\title{Ensure the specific columns of a dataframe have a particular type.}
\usage{
type_ensure(df, ensure_nms, type = "numeric")
}
\arguments{
\item{df}{A dataframe.}

\item{ensure_nms}{Character vector giving names of \code{df} to ensure \code{type}}

\item{type}{A string giving the type to ensure in columns \code{ensure_nms}}
}
\value{
A modified version of \code{df}, with columns (specified in \code{ensure_nms})
of type \code{type}.
}
\description{
Ensure the specific columns of a dataframe have a particular type.
}
\examples{
dfm <- tibble(
  w = c(NA, 1, 2),
  x = 1:3,
  y = as.character(1:3),
  z = letters[1:3]
)
dfm
type_ensure(dfm, c("w", "x", "y"), "numeric")
type_ensure(dfm, c("w", "x", "y", "z"), "character")
}
\seealso{
\code{\link[purrr:modify]{purrr::modify_at()}}.

Other functions to operate on column types: 
\code{\link{type_vft}()}

Other functions for developers: 
\code{\link{check_crucial_names}()},
\code{\link{extract_insensitive}()},
\code{\link{flag_if_group}()},
\code{\link{is_multiple}()},
\code{\link{nms_try_rename}()},
\code{\link{rename_matches}()}
}
\concept{functions for developers}
\concept{functions to operate on column types}
\keyword{internal}
