% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cyclical_sin}
\alias{cyclical_sin}
\title{Convert a Cyclical Variable to Sine Representation}
\usage{
cyclical_sin(x, period)
}
\arguments{
\item{x}{A numeric vector representing a cyclic variable (e.g., hour, month, day).}

\item{period}{A positive numeric scalar representing the period of the cycle.
For example, use 24 for hours of the day, 7 for days of the week, and 12 for months.}
}
\value{
A numeric vector representing the sine-transformed values.
}
\description{
This function transforms a cyclic variable (e.g., hour of the day, day of the week, month of the year)
into its sine representation. This transformation ensures that machine learning models respect
the cyclical nature of such features.
}
\details{
This function applies the transformation:
  \deqn{sin(2 * \pi * x / period)}
  This encoding ensures that the first and last values in the cycle are smoothly connected.
}
\examples{
# Convert hours of the day to sine encoding
hours <- 0:23
cyclical_sin(hours, 24)

# Convert months of the year to sine encoding
months <- 1:12
cyclical_sin(months, 12)

}
