% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influence.quan.R
\name{influence_quan}
\alias{influence_quan}
\title{Quantile for influence measures}
\usage{
influence_quan(model,out.influ,mue.boot=500,
smo=0.1,smoX=0.05,alpha=0.95,kmax.fix=FALSE,...)
}
\arguments{
\item{model}{\code{fregre.pc}, \code{fregre.basis} or \code{fregre.basis.cv}
object.}

\item{out.influ}{\code{inflluence.fd} bject}

\item{mue.boot}{Number of bootstrap samples}

\item{smo}{Smoothing parameter as a proportion of response variance.}

\item{smoX}{Smoothing parameter for \code{fdata} object as a proportion of
variance-covariance matrix of the explanatory functional variable.}

\item{alpha}{Significance level.}

\item{kmax.fix}{The maximum number of principal comoponents or number of
basis is fixed by \code{model} object.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Return:
\itemize{ 
\item \code{quan.cook.for}:  Distance Cook Prediction Quantile.
\item \code{quan.cook.est}: Distance Cook Estimation Quantile.
\item \code{quan.cook.Pena}: Pena Distance Quantile.
\item \code{mues.est}: Sample Cook generated. 
\item \code{mues.pena}: Sample Pena generated.
\item \code{beta.boot}: Functional beta estimated by bootstrap method.
}
}
\description{
Estimate the quantile of measures of influence for each observation.
}
\details{
Compute the quantile of measures of influence estimated in
\code{\link{influence.fregre.fd}} for functional regression using principal
components representation (\code{\link{fregre.pc}}) or basis
representation\cr (\code{\link{fregre.basis}} or
\code{\link{fregre.basis.cv}}).

A smoothed bootstrap method is used to estimate the quantiles of the influence measures, which allows to point out
which observations have the larger influence on estimation and prediction.
}
\examples{
\dontrun{
data(tecator)
x=tecator$absorp.fdata
y=tecator$y$Fat
res=fregre.pc(x,y,1:6)

#time consuming
res.infl=influence.fregre.fd(res)
resquan=influence_quan(res,res.infl,4,0.01,0.05,0.95)
plot(res.infl$betas,type="l",col=2)
lines(res$beta.est,type="l",col=3)
lines(resquan$betas.boot,type="l",col="gray")

res=fregre.basis(x,y)
res.infl=influence.fregre.fd(res)
resquan=influence_quan(res,res.infl,mue.boot=4,kmax.fix=T)
plot(resquan$betas.boot,type="l",col=4)
lines(res.infl$betas,type="l",col=2)
lines(resquan$betas.boot,type="l",col="gray")
}
}
\references{
Febrero-Bande, M., Galeano, P. and Gonzalez-Manteiga, W. (2010).
\emph{Measures of influence for the functional linear model with scalar
response}. Journal of Multivariate Analysis 101, 327-339.
}
\seealso{
See Also as: \code{\link{influence.fregre.fd}},
\code{\link{fregre.basis}}, \code{\link{fregre.pc}}.
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@udc.es}
}
\keyword{outliers}
