% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data.R
\name{get_codes_dict}
\alias{get_codes_dict}
\title{Retrieve dictionary of lookup codes for a specified dataset name}
\usage{
get_codes_dict(data_name)
}
\arguments{
\item{data_name}{A character string specifying the data name to retrieve the
codes dictionary for.}
}
\value{
A list with the codes dictionary (\code{codes_dict}) and the associated
variable name (\code{codes_varname}) if found, otherwise each element will be NULL.
}
\description{
\code{get_codes_dict()} searches for an internal .rda file in the specified package
and retrieves the codes dictionary based on the provided data name and naming
convention. The naming convention is assumed to include the data name followed
by a double underscore "__".
}
\details{
\code{get_codes_dict()} uses the provided data name to construct the expected naming
convention and searches for an internal .rda file in the specified package.
If found, it attempts to retrieve the codes dictionary using \code{get} and returns
it; otherwise, it returns NULL.
}
\examples{
\donttest{

  rcb_dict <- get_codes_dict("RCB")

  # Access codes dictionary
  rcb_dict$codes_dict

  # Access the name of the variable that stores the codes
  rcb_dict$codes_varname

}
}
