% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZINB2.R
\name{ZINB2}
\alias{ZINB2}
\title{Extended zero-inflated negative binomial regression}
\usage{
ZINB2(y, x)
}
\arguments{
\item{y}{A response vector.}

\item{x}{A data frame with covariates.}
}
\value{
A list of log-likelihood, estimated coefficients, and maximum likelihood estimation results.
}
\description{
Fit extended zero-inflated negative binomial regression model via maximum likelihood.
}
\details{
The model regresses all the parameters-- zero-inflation component \eqn{\pi} (with logit link), and both the mean \eqn{\mu}
and dispersion parameter \eqn{\theta} (with log link)-- on covariates.
}
\examples{
library(agridat)
library(bbmle)
sample<-sample(270, 30)
my_y<-ridout.appleshoots$roots[sample]
my_x<-data.frame(pho=ridout.appleshoots$pho[sample])
ZINB2(y=my_y, x=my_x  )

}
\references{
Breece, C. and Lee, J. (2024) Fractional binomial regression model for count data with excess zeros.\url{https://arxiv.org/html/2410.08488v1}
}
