% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_faunabr.R
\name{translate_faunabr}
\alias{translate_faunabr}
\title{Translate information in Brazilian Fauna database}
\usage{
translate_faunabr(data, map_list = NULL, to = "en")
}
\arguments{
\item{data}{(data.frame) the data.frame imported with the
\code{\link{load_faunabr}} function.}

\item{map_list}{(list) A list of data.frames used for translation. The default
is NULL, which means it uses \code{faunabr::map_translation}. If not NULL, its
structure (list names and data.frame column names) must be identical
to \code{faunabr::map_translation}.}

\item{to}{(character) The target language for translation. Available options
are "en" to translate from Portuguese to English, and "pt_br" to translate
from English to Portuguese. The default is "en".}
}
\value{
A data.frame with the values in the "lifeForm", "origin", "habitat",
"taxonRank", and "taxonomicStatus" columns translated.
}
\description{
This function translates information in the "lifeForm", "origin", "habitat",
"taxonRank", and "taxonomicStatus" columns between Portuguese and English.
}
\examples{
data("fauna_data") #Load data example (in English)
#Translate to Portuguese
fauna_portugues <- translate_faunabr(data = fauna_data, to = "pt_br")
# See attributes of lifeForm in Portuguese
fauna_attributes(fauna_portugues, attribute = "lifeForm")

}
