% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qr_lse_resid}
\alias{qr_lse_resid}
\title{Compute residuals using QR decomposition}
\usage{
qr_lse_resid(X, y)
}
\arguments{
\item{X}{numeric matrix of dimension \eqn{n \times p}.}

\item{y}{numeric response vector of length \eqn{n}.}
}
\value{
a numeric vector of residuals.
}
\description{
Computes the residual vector \eqn{r = y - \hat y} for a linear
least-squares problem using a QR decomposition computed internally.
}
\details{
The QR decomposition of \eqn{X} is computed internally. The residuals
are obtained as
\deqn{r = y - Q Q^\top y}
without explicitly forming the orthogonal matrix \eqn{Q}.

This function is intended as a convenience wrapper for least-squares
computations when the explicit QR factors are not required.
}
\examples{
set.seed(1)
n <- 10; p <- 4
X <- matrix(rnorm(n * p), n, p)
y <- rnorm(n)

r1 <- fastQR::qr_lse_resid(X, y)

## reference computation
r2 <- base::qr.resid(base::qr(X), y)

max(abs(r1 - r2))

}
