% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream.R
\name{stream.FASSTER}
\alias{stream.FASSTER}
\title{Stream new data through a FASSTER model}
\usage{
\method{stream}{FASSTER}(object, new_data, specials = NULL, ...)
}
\arguments{
\item{object}{A fitted FASSTER model object}

\item{new_data}{A tsibble containing new observations to stream through the model}

\item{specials}{A list of special terms (switching variables, etc.) parsed from the model formula}

\item{...}{Additional arguments (currently unused)}
}
\value{
An updated FASSTER model object with:
\itemize{
\item Extended state estimates incorporating the new data
\item Updated model variance
\item Appended fitted values and residuals
\item Updated DLM components for future forecasting
}
}
\description{
Extends a fitted FASSTER model by filtering new observations through the
existing state space model. The model's states and parameters are updated
sequentially as new data arrives, allowing for online learning without
refitting from scratch.
}
\details{
The streaming process:
\enumerate{
\item Constructs the design matrix from new data
\item Applies the Kalman filter to sequentially update states
\item Updates model variance based on all residuals
\item Prepares the model for subsequent forecasting or streaming
}
}
\examples{
library(tsibble)
library(fasster)

# Fit initial model on training data
fit <- as_tsibble(head(USAccDeaths, -12)) |>
  model(fasster = FASSTER(value ~ trend() + season("year")))
tidy(fit)
tail(fitted(fit), 20)

# Stream new data through the model
fit_updated <- fit |>
  stream(as_tsibble(tail(USAccDeaths, 12)))
tidy(fit_updated)
tail(fitted(fit_updated), 20)

}
