% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_dst.R
\name{fit_dst}
\alias{fit_dst}
\title{Fit a distribution}
\usage{
fit_dst(
  family,
  x,
  method = c("mle", "mge", "mme", "lmom", "lmom-log"),
  na_action = c("null", "drop", "fail"),
  on_unres = c("null", "fail")
)
}
\arguments{
\item{family}{Name of the target distribution family, such as \code{"norm"},
\code{"gev"}, \code{"pois"}. See details. Character vector of length 1.}

\item{x}{Numeric vector containing the observations to fit.}

\item{method}{Estimation method to use. Valid choices include \code{"mle"},
\code{"mge"}, \code{"mme"}, \code{"lmom"}, and \code{"lmom-log"}. The default is \code{"mle"},
although beware that not all families support the \code{"mle"} method yet
(pearson3 and lp3).}

\item{na_action}{Strategy for dealing with \code{NA} values in \code{x}.
\code{"null"} returns a Null distribution (\code{distionary::dst_null()});
\code{"drop"} silently removes missing observations before fitting; and
\code{"fail"} aborts with an error.}

\item{on_unres}{Behaviour when no distribution can be resolved for the
supplied inputs. \code{"null"} (default) yields a Null distribution
(\code{distionary::dst_null()}) distribution with a warning,
whereas \code{"fail"} propagates an error.}
}
\value{
A distribution object of class "dst" encapsulating the fitted
distribution.
}
\description{
Estimation of probability distributions available in the 'distionary'
package. Wraps the 'lmom' package when fitting by L-moments,
the 'ismev' package when fitting the GP/GEV/Gumbel by MLE, and the
'fitdistrplus' package for other combinations.
}
\details{
The \code{fit_dst()} function is currently a lightweight fitting wrapper,
with pre-specified behaviour for certain \code{family} / \code{method} combinations.
A full list of families and their compatible estimation methods is available
via specific family wrappers, such as \code{fit_dst_norm()}, \code{fit_dst_pois()},
etc.

Here is how fitting is implemented.

\itemize{
\item For \code{method = "lmom"} and distribution families 'gamma', 'gev', 'gp',
'gumbel', 'lnorm', 'norm', 'pearson3', and 'weibull',
the 'lmom' package is wrapped by first calling
\code{lmom::samlmu()} on the data vector \code{x} to calculate the L-moments,
then the relevant \verb{lmom::pel*()} function is called to estimate
parameters.
\item For \code{method = "lmom"} and distribution families
'exp', 'pois', 'bern', 'geom', 'chisq', and 'unif', the method of
L-moments is manually implemented. All of these families except 'unif'
have a single parameter for which only the mean is needed (and thus is
equivalent to the 'mme' method). The 'unif' family has minimum and
maximum parameter values calculated as \code{l1 - 3 * l2} and  \code{l1 + 3 * l2},
where \code{l1} and \code{l2} are the first and second L-moments
(see Hosking, 1990, Table 1).
\item For \code{method = "lmom-log"}, only the 'lnorm' and 'lp3' families are
supported, otherwise no distribution will be resolved. The method fits
the distributions via the 'lmom' method on the log scale. That is,
'norm' and 'pearson3' distributions are fit on the log of
the data, for which the respective 'lnorm' or 'lp3' distribution is
obtained.
\item For \code{method = "mle"} and distribution families 'gev', 'gp', or
'gumbel', the 'ismev' package is used to fit the distribution by maximum
likelihood estimation. This is done by invoking the functions
\code{ismev::gev.fit()}, \code{ismev::gpd.fit()} (with \code{threshold = 0}),
and \code{ismev::gum.fit()} (respectively).
\item For \code{method = "mle"} and distribution family 'bern' and 'degenerate',
the MLE is calculated manually. For 'bern', the parameter
is estimated as the mean of the 0-1 data; for 'degenerate', the
unique data value.
\item For \code{method = "mme"} and \code{"lmom"}, the 'cauchy' family fails to fit
because Cauchy distributions don't have finite moments (Feller, 1971).
\item For families 'empirical' and 'finite', the empirical distribution
is fit to the supplied data.
\item For the 'null' family, a Null distribution is returned.
\item For any other combination of \code{family} and \code{method}, the
\code{fitdistrplus::fitdist()} function is called by inserting the data \code{x},
the \code{family} name, and the \code{method}. Some distributions require
starting values for the parameters. For the families 't',
'f', and 'chisq', this is done by moment matching ('mme').
For 'gev', 'gp', and 'gumbel', the MLE is used as
starting values (through \code{method = "mle"}).
}

To understand what the distribution families are, see the documentation
in the 'distionary' package through the \verb{dst_*()} functions.
For example, the 'lp3' family can be found at \code{?distionary::dst_lp3()}.
Note that the Gumbel distribution is not available yet in 'distionary',
but is simply the 'gev' family with \code{shape = 0}.

To understand the estimation methods, see the 'lmom' package for the
\code{"lmom"} method. For the \code{"lmom-log"} method, it is the same as \code{"lmom"}, but
via the log of the data and the corresponding log-transformed distributions.
For all others, see the 'fitdistrplus' package documentation.
\subsection{Handling of missing or unresolvable data}{

When \code{na_action = "drop"}, the function operates on the subset of \code{x}
without missing values (via \code{x <- x[!is.na(x)]}). This takes priority over
behaviour indicated in \code{on_unres}.

If fitting fails, a Null distribution is output if \code{on_unres = "null"} (the
default), or an error is thrown if \code{on_unres = "fail"}. Fitting can fail
due to not having enough data, not being able to isolate a single
distribution, or various other reasons that would typically otherwise
result in an error or \code{NA} parameters in the wrapped fitting method.
}
}
\examples{
fit_dst("norm", x = 1:10, method = "mle")
fit_dst("gev", x = c(1, 4, 3, NA, 5), method = "lmom", na_action = "drop")
fit_dst("pois", x = c(1, 4, 3, NA, 5), na_action = "null")

# "lnorm" with "lmom-log" shares parameters with "norm" fit by "lmom".
fit_dst("lnorm", x = 1:10, method = "lmom-log")
fit_dst("norm", x = log(1:10), method = "lmom")
}
\references{
Hosking, J. R. M. (1990). L-moments: Analysis and estimation of distributions
using linear combinations of order statistics. \emph{Journal of the Royal
Statistical Society: Series B (Methodological)}, 52(1), 105–124.

Feller, W. (1971). \emph{An Introduction to Probability Theory and Its
Applications} (Vol. 2, 2nd ed.). Wiley.
}
\seealso{
\verb{fit_dst_*()} helpers such as \code{\link[=fit_dst_norm]{fit_dst_norm()}}.
}
