% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/center-test.R
\name{center.test}
\alias{center.test}
\title{Center test}
\usage{
center.test(
  x,
  y = NULL,
  family = "huber",
  alternative = c("two.sided", "less", "greater"),
  mu = 0,
  paired = FALSE,
  nboot = 1000,
  loss = NULL,
  cluster = NULL,
  ...
)
}
\arguments{
\item{x}{a numeric vector of data}

\item{y}{an optional numeric vector of data}

\item{family}{the family of centers; currently only allows 'huber' for Huber family}

\item{alternative}{the form of the alternative hypothesis; must be one of 'two.sided' (default),
'greater', or 'less'}

\item{mu}{the null value of the center for a one-sample test, or the
null value of the center of differences for a paired two-sample test, or the null value of the
difference of centers for an independent two-sample test; can be an interval}

\item{paired}{a logical indicating whether to treat \code{x} and \code{y} as paired}

\item{nboot}{the number of bootstraps to perform}

\item{loss}{an optional c×2 matrix of losses incurred from an incorrect decision, where c is the
number of candidate choices (typically c=3: H0, H1, or indeterminate)}

\item{cluster}{an optional cluster for running bootstraps in parallel; must be set up using
\code{parallel::makeCluster}}

\item{...}{any other arguments}
}
\value{
An object of class \code{center.test}; a list with the following components:
\item{expected.loss}{the expected loss, calculated by post-multiplying \code{loss} with
\code{prob}}
\item{decision}{the optimal decision given the expected loss}
\item{loss}{the loss matrix}
\item{prob}{the estimated posterior probabilities of the null and alternative}
\item{boot}{the bootstrap output from \code{bayes.boot}}
\item{x}{the \code{x} that was supplied}
\item{y}{the \code{y} that was supplied}
\item{mu}{the \code{mu} that was supplied}
\item{family}{the \code{family} that was supplied}
}
\description{
Performs a one- or two-sample test for a family of centers.
}
\details{
Uses the Bayesian bootstrap to compute posterior probabilities for the hypotheses
\eqn{\mathrm{H}_0:\mu(\lambda)=\mu_0} for some \eqn{\lambda\in\Lambda} vs.
\eqn{\mathrm{H}_1:\mu(\lambda)\neq\mu_0} for all \eqn{\lambda\in\Lambda},
where \eqn{\{\mu(\lambda):\lambda\in\Lambda\}} is a family of centers. \cr
The default loss matrix results in a decision whenever the posterior probability
for one of the hypotheses is greater than 0.95 and otherwise is indeterminate.
}
\examples{
set.seed(123)

test <- center.test(MASS::galaxies, mu = 21000, nboot = 100)
print(test)
plot(test)

cl <- parallel::makeCluster(2)
test <- center.test(MASS::galaxies, mu = 21000, nboot = 100, cluster = cl)
parallel::stopCluster(cl)
print(test)
}
\references{
Thompson, R., Forbes, C. S., MacEachern, S. N., and Peruggia, M. (2024). 'Familial
inference: Tests for hypotheses on a family of centres'. Biometrika 111.3, pp. 1029–1045.
}
\author{
Ryan Thompson <ryan.thompson-1@uts.edu.au>
}
