% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dates.R
\name{as_any_date}
\alias{as_any_date}
\title{Create objects of class "Date"}
\usage{
as_any_date(
  x = as.character(),
  format = c("dmy", "dym", "ymd", "ydm", "mdy", "myd", "my", "ym", "as_date")
)
}
\arguments{
\item{x}{object to be coerced.}

\item{format}{A character identifying the format to apply to the object.
That format can be 'ymd','ydm','dym','dmy','mdy','myd','my','ym'.}
}
\value{
A R Object of class 'Date'.
}
\description{
This function takes a character string or a vector. This vector is evaluates
one observation after the other, and casts the best matching date format
for each of them (independently). The best matching format is tested across
seven different formats provided by the lubridate library. The user can
specify the wanted matching format (and can be helped using
\code{\link[=which_any_date]{which_any_date()}} for each value or \code{\link[=guess_date_format]{guess_date_format()}}
for the values as a whole.
}
\details{
Contrary to lubridate library or \code{\link[=as.Date]{as.Date()}}, the function evaluates
the different possibilities for a date. For example, c('02-03-1982') can be
either March the 2nd or February the 3rd. The function will cast the value as
NA, and a warning, since there is an ambiguity that cannot be solved, unless
the user provides the format to apply.
}
\examples{
{

library(dplyr)
library(tidyr)

##### Example 1 -------------------------------------------------------------
# Ambiguous dates -----------------------------------------------------------
as_any_date('19 02 12')
as_any_date('19 02 12', format = "ymd")
as_any_date('19 02 12', format = "dym")

##### Example 2 -------------------------------------------------------------
# Non-ambiguous dates -------------------------------------------------------
time <-
  tibble(time = c(
  "1983 07-19",
  "14-01-1925",
  "12/13/2015",
  "2009-09-13",
  "17-12-12",
  "coucou",
  "2025 jan the 30th",
  "1809-01-19"))

time \%>\% mutate(new_time = as_any_date(time))

}

}
\seealso{
\code{\link[lubridate:ymd]{lubridate::ymd()}},\code{\link[lubridate:ymd]{lubridate::ydm()}},\code{\link[lubridate:ymd]{lubridate::dmy()}},
\code{\link[lubridate:ymd]{lubridate::myd()}},\code{\link[lubridate:ymd]{lubridate::mdy()}},\code{\link[lubridate:ymd]{lubridate::dym()}},
\code{\link[lubridate:ymd]{lubridate::my()}} ,\code{\link[lubridate:ymd]{lubridate::ym()}},
\code{\link[lubridate:as_date]{lubridate::as_date()}},\code{\link[=as.Date]{as.Date()}},
\code{\link[=guess_date_format]{guess_date_format()}},\code{\link[=which_any_date]{which_any_date()}}
}
