% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popular-methods.R
\name{residuals,fEGarch_fit-method}
\alias{residuals,fEGarch_fit-method}
\title{Extract Standardized Residuals}
\usage{
\S4method{residuals}{fEGarch_fit}(object)
}
\arguments{
\item{object}{an object either of class \code{"fEGarch_fit"} or
\code{"fEGarch_forecast"}.}
}
\value{
The element within the input object with name \code{etat} is returned.
Depending on the element that can be a numeric vector, an object of
class "zoo" or a numeric matrix.
}
\description{
An alternative to \code{\link{etat,fEGarch_fit-method}} to extract
standardized residuals from an estimation object
in this package.
}
\details{
Extract fitted standardized residuals from an estimation object
in this package.
}
\examples{
window.zoo <- get("window.zoo", envir = asNamespace("zoo"))
rt <- window.zoo(SP500, end = "2002-12-31")
model <- fEGarch(egarch_spec(), rt, n_test = 250)
residuals(model)

}
