% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_interval_wz_di.R
\name{wz_ci_di}
\alias{wz_ci_di}
\alias{confidence_interval_wz_di}
\alias{ci_wz_format_di}
\title{Confidence Intervals for Extinction Probability (w–z, DI model)}
\usage{
confidence_interval_wz_di(mu, xd, s, th, tq, qq, alpha, prob_fun = ext_prob_di)

ci_wz_format_di(mu, xd, s, th, tq, qq, alpha, digits = 5L)
}
\arguments{
\item{mu}{Numeric. Estimated growth rate \eqn{\hat{\mu}}.}

\item{xd}{Numeric. Log-distance to threshold \eqn{x_d=\log(n_q/n_e)}.}

\item{s}{Numeric. Estimated environmental variance \eqn{\hat{\sigma}^2}.}

\item{th}{Numeric. Time horizon \eqn{t^{\ast}} for evaluation.}

\item{tq}{Numeric. Observation span \eqn{t_q} (first to last time).}

\item{qq}{Integer. Number of intervals \eqn{q} (sample size minus 1).}

\item{alpha}{Numeric. Significance level \eqn{\alpha}\,=\,1\,-\,CL.}

\item{prob_fun}{Function. One of \code{ext_prob_di},
\code{log_ext_prob_di}, \code{log_ext_comp_di}.}

\item{digits}{Integer. Significant digits for formatting (used only by
\code{ci_wz_format_di}).}
}
\value{
For \code{confidence_interval_wz_di}: numeric vector \code{c(lower, upper)}
on the chosen scale (natural log if \code{log_*}).\cr
For \code{ci_wz_format_di}: named character vector \code{c(lower, upper)}
with values preformatted for display.
}
\description{
Computes confidence intervals (CIs) for extinction probability in a
density-independent (drifted Wiener) model using the w–z method, and
provides a formatter for display-ready CI strings.
}
\details{
The w–z method derives CIs by inverting noncentral-\eqn{t}
distributions for the transformed statistics \eqn{w} and \eqn{z},
then combining them to form bounds on \eqn{G(w,z)}.

Exact confidence intervals for \eqn{w} and \eqn{z} are obtained by
numerically solving the noncentral-\eqn{t} quantile equations
corresponding to the observed statistics.

The CI for \eqn{G(w,z)} is then approximated by
\deqn{
  \bigl( G(\overline{w},\,\underline{z}),\;
         G(\underline{w},\,\overline{z}) \bigr),
}
where \eqn{\overline{w}}, \eqn{\underline{w}},
\eqn{\overline{z}}, and \eqn{\underline{z}} are the upper and lower
confidence limits for \eqn{w} and \eqn{z}, respectively.
Across the full parameter space, this approach achieves near-nominal
coverage. When $z$ is large and positive, $G$ depends only on $w$, so
exact CIs are available.

The argument \code{prob_fun} selects which probability is evaluated:
\itemize{
\item \code{ext_prob_di}, \code{log_ext_prob_di}:
CIs for \eqn{G(w,z)} and \eqn{\log G(w,z)};
returned as (lower, upper).
\item \code{log_ext_comp_di}:
CIs for \eqn{\log Q(w,z)= \log (1-G(w,z))};
returned as (lower, upper).
}
}
\author{
Hiroshi Hakoyama, \email{hiroshi.hakoyama@gmail.com}
}
\keyword{internal}
