\name{exams2wooclap}
\alias{exams2wooclap}

\title{Generation of Quizzes for Wooclap}

\description{
   Automatic generation of quizzes in Moodle XML format with some tweaks
   (still under development) for the audience response system Wooclap.
}

\usage{
  exams2wooclap(file, n = 1L, dir = ".", name = "moodletowooclap", \dots)
}


\arguments{
  \item{file}{character. A specification of a (list of) exercise files.}
  \item{n}{integer. The number of copies to be compiled from \code{file}.}
  \item{dir}{character. The default is the current working directory.}
  \item{name}{character. A name prefix for resulting exercises and XML file.}
  \item{\dots}{arguments passed on to \code{\link[exams]{exams2moodle}}.}
}

\details{
  \code{exams2wooclap} is a convenience interface to \code{\link[exams]{exams2moodle}}
  for generating Moodle XML with some small tweaks for Wooclap
  (\url{https://www.wooclap.com}). (For the most recent description of the compatibility
  between the Moodle and Wooclap platforms see
  \url{https://docs.wooclap.com/en/articles/1980934-can-i-move-questions-from-wooclap-to-moodle},
  and the link to the Google doc under 'Step 1: Export Moodle questions to Moodle XML format'.)
  At the moment the supported exercise types are num, schoice, mchoice, and string.
  There is only limited support for cloze exercises. 

  The Wooclap-specific tweaks currently include:
  \itemize{
    \item The Wooclap system does not properly render html-\code{<pre>} environments and requires an
    additional adjustment of the Moodle XML.
  }

  \emph{Technical notes:} As Wooclap only allows for very basic markup,
  the format of tables created with LaTeX or Markdown gets lost in the conversion.
  Also, for numerical questions the tolerance is not picked up when uploading into Wooclap. Note that these
  issues do not originate from \code{\link[exams]{exams2wooclap}}, but are a result of imperfections
  in Wooclap. The Wooclap project team has expressed that fixing the latter issue has limited priority 
  for future improvements.

}

\references{
Wooclap (2025). \emph{Event features and settings}.
  Available at \url{https://docs.wooclap.com/en/collections/2357545-event-features-and-settings}

Zeileis A, Umlauf N, Leisch F (2014).
  Flexible Generation of E-Learning Exams in R: Moodle Quizzes, OLAT Assessments, and Beyond.
  \emph{Journal of Statistical Software}, \bold{58}(1), 1--36.
  \doi{10.18637/jss.v058.i01}.
}

\value{
  \code{exams2wooclap} returns a list of exams as generated by \code{\link[exams]{xexams}}.
}

\seealso{
  \code{\link[exams]{exams2moodle}}
}

\examples{
\donttest{
## load package and enforce par(ask = FALSE)
library("exams")
options(device.ask.default = FALSE)

## define an exams (= list of exercises)
myexam <- c(
  "boxplots.Rmd",
  "tstat.Rmd",
  "ttest.Rmd",
  "relfreq.Rmd"
)

## output directory
dir.create(mydir <- tempfile())

## generate .xml with Wooclap quiz in temporary directory
exams2wooclap(myexam, dir = mydir)
dir(mydir)
}
}

\keyword{utilities}
