% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R, R/sos.R
\docType{data}
\name{sos100}
\alias{sos100}
\alias{sos200}
\alias{sos400}
\alias{sos800}
\alias{sos}
\title{Precomputed Sum of Squared Data}
\format{
For each line of a matrix it holds \eqn{\sum_{i=1}^k x_i^2=n} and \eqn{\sum_{i=1}^k x_i=0}.
It contains all integer solutions up to \code{k<=10}. \code{NA} means that this entry is not used.
}
\usage{
data(sos100)
data(sos200)
data(sos400)
data(sos800)

sos200

sos400

sos800

sos(n, nmax = 10, quiet = !interactive())
}
\arguments{
\item{n}{Integer, specifying the dataset index (e.g., \code{n = 3} returns \code{sos3}).}

\item{nmax}{Integer, the maximum value passed to \code{sumofsquares()}.
Defaults to \code{10}.}

\item{quiet}{Logical. If \code{FALSE}, progress messages are printed.
Defaults to \code{!interactive()}.}
}
\value{
An \R object named \code{sosN}, corresponding to the requested dataset.
If no solution exists for the given \code{n}, a matrix with a single row
filled with \code{NA} values is returned.
}
\description{
Five data matrices with precomputed results from \code{sumofsquares(n, 10, zerosum=TRUE, maxt=Inf)} for
\code{n=100}, \code{n=200}, \code{n=400}, and \code{n=800}.

More generally, datasets can be accessed using \code{sos(n, nmax)}, which
retrieves or computes results from \code{sumofsquares(n, nmax, zerosum=TRUE, maxt=Inf)}.

The function \code{sos()} retrieves a dataset of the form \code{sosN}, where
\code{N} is the input parameter \code{n}. The function tries several sources
in order:
\enumerate{
\item Load from the package \code{exams.forge} if available.
\item Load from the user data directory (see \code{\link[tools]{R_user_dir}}).
\item Download from a GitHub repository.
\item Compute the dataset on the fly using \code{sumofsquares()}.
}
}
\details{
In steps 3 and 4, the dataset is cached in the user data directory (compressed
with \code{xz}). If the directory does not exist and the session is interactive,
the user is prompted for permission to create it; otherwise a temporary
directory is used. In non-interactive sessions, the directory is used only
if it already exists, otherwise \code{tempdir()} is used silently.

The computation step calls:
\preformatted{
  sumofsquares(n, nmax, maxt = Inf, zerosum = TRUE)
}
}
\examples{
data(sos100)
head(sos100)
rowSums(sos100^2, na.rm=TRUE)
rowSums(sos100, na.rm=TRUE)
x100 <- sos(100) # part of the package
rowSums(x100, na.rm=TRUE)     # only zeros
rowSums(x100^2, na.rm=TRUE)   # only 100's
x144 <- sos(144) # must be computed 
rowSums(x144, na.rm=TRUE)     # only zeros
rowSums(x144^2, na.rm=TRUE)   # only 144's

}
\seealso{
\code{\link[tools]{R_user_dir}}, \code{\link{sumofsquares}}
}
\keyword{datasets}
