% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanFile.R
\name{cleanFile}
\alias{cleanFile}
\title{Clean or Schedule Deletion of a File}
\usage{
cleanFile(file, delay)
}
\arguments{
\item{file}{Character string. Path to the file to be deleted.}

\item{delay}{Numeric. Number of seconds to wait before deleting the file.
If \code{delay = 0}, the file will persist until the R session ends.}
}
\value{
Invisibly returns the file path.
}
\description{
Deletes a file immediately after a specified delay or schedules it for deletion
when the R session ends.
}
\examples{
# Delete a temporary file after 2 seconds
tmp <- tempfile()
file.create(tmp)
cleanFile(tmp, delay = 2)

# Keep a temporary file until the R session ends
tmp2 <- tempfile()
file.create(tmp2)
cleanFile(tmp2, delay = 0)
}
